/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.fixture;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.configuration.ApplicationConfigurer;
import org.axonframework.configuration.AxonConfiguration;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.ConfigurationEnhancer;
import org.axonframework.eventhandling.EventSink;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.test.FixtureExecutionException;
import org.axonframework.test.fixture.AxonTestGiven;
import org.axonframework.test.fixture.AxonTestPhase;
import org.axonframework.test.fixture.AxonTestWhen;
import org.axonframework.test.fixture.MessagesRecordingConfigurationEnhancer;
import org.axonframework.test.fixture.RecordingCommandBus;
import org.axonframework.test.fixture.RecordingEventSink;
import org.axonframework.test.matchers.FieldFilter;
import org.axonframework.test.matchers.IgnoreField;

public class AxonTestFixture
implements AxonTestPhase.Setup {
    private final Configuration configuration;
    private final Customization customization;
    private final MessageTypeResolver messageTypeResolver;
    private final RecordingCommandBus commandBus;
    private final RecordingEventSink eventSink;

    AxonTestFixture(@Nonnull Configuration configuration, @Nonnull UnaryOperator<Customization> customization) {
        this.customization = (Customization)customization.apply(new Customization());
        this.configuration = configuration;
        this.messageTypeResolver = (MessageTypeResolver)configuration.getComponent(MessageTypeResolver.class);
        CommandBus commandBusComponent = (CommandBus)configuration.getComponent(CommandBus.class);
        if (!(commandBusComponent instanceof RecordingCommandBus)) {
            throw new FixtureExecutionException("CommandBus is not a RecordingCommandBus. This may happen in Spring environments where the MessagesRecordingConfigurationEnhancer is not properly registered. Please declare MessagesRecordingConfigurationEnhancer as a bean in your test context. Note: This configuration may be subject to change until the 5.0.0 release.");
        }
        this.commandBus = (RecordingCommandBus)commandBusComponent;
        EventSink eventSinkComponent = (EventSink)configuration.getComponent(EventSink.class);
        if (!(eventSinkComponent instanceof RecordingEventSink)) {
            throw new FixtureExecutionException("EventSink is not a RecordingEventSink. This may happen in Spring environments where the MessagesRecordingConfigurationEnhancer is not properly registered. Please declare MessagesRecordingConfigurationEnhancer as a bean in your test context. Note: This configuration may be subject to change until the 5.0.0 release.");
        }
        this.eventSink = (RecordingEventSink)eventSinkComponent;
    }

    public static AxonTestFixture with(@Nonnull ApplicationConfigurer configurer) {
        return AxonTestFixture.with(configurer, c -> c);
    }

    public static AxonTestFixture with(@Nonnull ApplicationConfigurer configurer, @Nonnull UnaryOperator<Customization> customization) {
        Objects.requireNonNull(configurer, "Configurer may not be null");
        Objects.requireNonNull(customization, "Customization may not be null");
        AxonConfiguration configuration = configurer.componentRegistry(cr -> cr.registerEnhancer((ConfigurationEnhancer)new MessagesRecordingConfigurationEnhancer())).start();
        return new AxonTestFixture((Configuration)configuration, customization);
    }

    @Override
    public AxonTestPhase.Given given() {
        return new AxonTestGiven(this.configuration, this.customization, this.commandBus, this.eventSink, this.messageTypeResolver);
    }

    @Override
    public AxonTestPhase.When when() {
        return new AxonTestWhen(this.configuration, this.customization, this.messageTypeResolver, this.commandBus, this.eventSink);
    }

    public record Customization(List<FieldFilter> fieldFilters) {
        public Customization() {
            this(new ArrayList<FieldFilter>());
        }

        public Customization registerFieldFilter(@Nonnull FieldFilter fieldFilter) {
            this.fieldFilters.add(fieldFilter);
            return this;
        }

        public Customization registerIgnoredField(@Nonnull Class<?> declaringClass, @Nonnull String fieldName) {
            return this.registerFieldFilter(new IgnoreField(declaringClass, fieldName));
        }
    }
}

