/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.server;

import java.util.Objects;
import java.util.Optional;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class AxonServerEEContainer<SELF extends AxonServerEEContainer<SELF>>
extends GenericContainer<SELF> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"axoniq/axonserver-enterprise");
    private static final int AXON_SERVER_HTTP_PORT = 8024;
    private static final int AXON_SERVER_GRPC_PORT = 8124;
    private static final String WAIT_FOR_LOG_MESSAGE = ".*Started AxonServer.*";
    private static final String LICENCE_DEFAULT_LOCATION = "/axonserver/config/axoniq.license";
    private static final String CONFIGURATION_DEFAULT_LOCATION = "/axonserver/config/axonserver.properties";
    private static final String CLUSTER_TEMPLATE_DEFAULT_LOCATION = "/axonserver/cluster-template.yml";
    private static final String AXONIQ_LICENSE = "AXONIQ_LICENSE";
    private static final String AXONIQ_AXONSERVER_NAME = "AXONIQ_AXONSERVER_NAME";
    private static final String AXONIQ_AXONSERVER_INTERNAL_HOSTNAME = "AXONIQ_AXONSERVER_INTERNAL_HOSTNAME";
    private static final String AXONIQ_AXONSERVER_HOSTNAME = "AXONIQ_AXONSERVER_HOSTNAME";
    private static final String AXON_SERVER_ADDRESS_TEMPLATE = "%s:%s";
    private String licensePath;
    private String configurationPath;
    private String clusterTemplatePath;
    private String axonServerName;
    private String axonServerInternalHostname;
    private String axonServerHostname;

    public AxonServerEEContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public AxonServerEEContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{8024, 8124});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)WAIT_FOR_LOG_MESSAGE, (int)1));
        this.withEnv(AXONIQ_LICENSE, LICENCE_DEFAULT_LOCATION);
    }

    protected void configure() {
        this.optionallyCopyResourceToContainer(LICENCE_DEFAULT_LOCATION, this.licensePath);
        this.optionallyCopyResourceToContainer(CONFIGURATION_DEFAULT_LOCATION, this.configurationPath);
        this.optionallyCopyResourceToContainer(CLUSTER_TEMPLATE_DEFAULT_LOCATION, this.clusterTemplatePath);
        this.withOptionalEnv(AXONIQ_AXONSERVER_NAME, this.axonServerName);
        this.withOptionalEnv(AXONIQ_AXONSERVER_HOSTNAME, this.axonServerHostname);
        this.withOptionalEnv(AXONIQ_AXONSERVER_INTERNAL_HOSTNAME, this.axonServerInternalHostname);
    }

    protected void optionallyCopyResourceToContainer(String pathNameInContainer, String resourceLocation) {
        Optional.ofNullable(resourceLocation).map(MountableFile::forClasspathResource).ifPresent(mountableFile -> {
            AxonServerEEContainer cfr_ignored_0 = (AxonServerEEContainer)this.withCopyFileToContainer((MountableFile)mountableFile, pathNameInContainer);
        });
    }

    protected void withOptionalEnv(String key, String value) {
        Optional.ofNullable(value).ifPresent(v -> {
            AxonServerEEContainer cfr_ignored_0 = (AxonServerEEContainer)this.withEnv(key, value);
        });
    }

    public SELF withLicense(String licensePath) {
        this.licensePath = licensePath;
        return (SELF)((Object)((AxonServerEEContainer)this.self()));
    }

    public SELF withConfiguration(String configurationPath) {
        this.configurationPath = configurationPath;
        return (SELF)((Object)((AxonServerEEContainer)this.self()));
    }

    public SELF withClusterTemplate(String clusterTemplatePath) {
        this.clusterTemplatePath = clusterTemplatePath;
        return (SELF)((Object)((AxonServerEEContainer)this.self()));
    }

    public SELF withAxonServerName(String axonServerName) {
        this.axonServerName = axonServerName;
        return (SELF)((Object)((AxonServerEEContainer)this.self()));
    }

    public SELF withAxonServerInternalHostname(String axonServerInternalHostname) {
        this.axonServerInternalHostname = axonServerInternalHostname;
        return (SELF)((Object)((AxonServerEEContainer)this.self()));
    }

    public SELF withAxonServerHostname(String axonServerHostname) {
        this.axonServerHostname = axonServerHostname;
        return (SELF)((Object)((AxonServerEEContainer)this.self()));
    }

    public Integer getGrpcPort() {
        return this.getMappedPort(8124);
    }

    public String getAxonServerAddress() {
        return String.format(AXON_SERVER_ADDRESS_TEMPLATE, this.getHost(), this.getMappedPort(8124));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AxonServerEEContainer that = (AxonServerEEContainer)((Object)o);
        return Objects.equals(this.licensePath, that.licensePath) && Objects.equals(this.configurationPath, that.configurationPath) && Objects.equals(this.clusterTemplatePath, that.clusterTemplatePath) && Objects.equals(this.axonServerName, that.axonServerName) && Objects.equals(this.axonServerInternalHostname, that.axonServerInternalHostname) && Objects.equals(this.axonServerHostname, that.axonServerHostname);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.licensePath, this.configurationPath, this.clusterTemplatePath, this.axonServerName, this.axonServerInternalHostname, this.axonServerHostname);
    }

    public String toString() {
        return "AxonServerEEContainer{licensePath='" + this.licensePath + '\'' + ", configurationPath='" + this.configurationPath + '\'' + ", clusterTemplatePath='" + this.clusterTemplatePath + '\'' + ", axonServerName='" + this.axonServerName + '\'' + ", axonServerInternalHostname='" + this.axonServerInternalHostname + '\'' + ", axonServerHostname='" + this.axonServerHostname + '\'' + '}';
    }
}

