/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.eventscheduler;

import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.scheduling.EventScheduler;
import org.axonframework.eventhandling.scheduling.ScheduleToken;
import org.axonframework.test.eventscheduler.EventConsumer;
import org.axonframework.test.eventscheduler.ScheduledItem;
import org.axonframework.test.eventscheduler.StubScheduleToken;

public class StubEventScheduler
implements EventScheduler {
    private final NavigableSet<StubScheduleToken> scheduledEvents = new TreeSet<StubScheduleToken>();
    private final AtomicInteger counter = new AtomicInteger(0);
    private Instant currentDateTime;

    public StubEventScheduler() {
        this(ZonedDateTime.now());
    }

    public StubEventScheduler(TemporalAccessor currentDateTime) {
        this.currentDateTime = Instant.from(currentDateTime);
    }

    public void initializeAt(TemporalAccessor currentDateTime) {
        if (!this.scheduledEvents.isEmpty()) {
            throw new IllegalStateException("Initializing the scheduler at a specific dateTime must take place before any events are scheduled");
        }
        this.currentDateTime = Instant.from(currentDateTime);
    }

    public ScheduleToken schedule(Instant triggerDateTime, Object event) {
        EventMessage eventMessage = GenericEventMessage.asEventMessage((Object)event);
        StubScheduleToken token = new StubScheduleToken(triggerDateTime, eventMessage, this.counter.getAndIncrement());
        this.scheduledEvents.add(token);
        return token;
    }

    public ScheduleToken schedule(Duration triggerDuration, Object event) {
        EventMessage eventMessage = GenericEventMessage.asEventMessage((Object)event);
        Instant scheduleTime = this.currentDateTime.plus(triggerDuration);
        StubScheduleToken token = new StubScheduleToken(scheduleTime, eventMessage, this.counter.getAndIncrement());
        this.scheduledEvents.add(token);
        return token;
    }

    public void cancelSchedule(ScheduleToken scheduleToken) {
        if (!(scheduleToken instanceof StubScheduleToken)) {
            throw new IllegalArgumentException("Wrong token type. This token was not provided by this scheduler");
        }
        this.scheduledEvents.remove(scheduleToken);
    }

    public List<ScheduledItem> getScheduledItems() {
        return new ArrayList<ScheduledItem>(this.scheduledEvents);
    }

    public Instant getCurrentDateTime() {
        return this.currentDateTime;
    }

    public EventMessage advanceToNextTrigger() {
        StubScheduleToken nextItem = this.scheduledEvents.pollFirst();
        if (nextItem == null) {
            throw new NoSuchElementException("There are no scheduled events");
        }
        if (nextItem.getScheduleTime().isAfter(this.currentDateTime)) {
            this.currentDateTime = nextItem.getScheduleTime();
        }
        return nextItem.getEvent();
    }

    public void advanceTimeTo(Instant newDateTime, EventConsumer<EventMessage<?>> eventConsumer) {
        while (!this.scheduledEvents.isEmpty() && !((StubScheduleToken)this.scheduledEvents.first()).getScheduleTime().isAfter(newDateTime)) {
            eventConsumer.accept(this.advanceToNextTrigger());
        }
        if (newDateTime.isAfter(this.currentDateTime)) {
            this.currentDateTime = newDateTime;
        }
    }

    public void advanceTimeBy(Duration duration, EventConsumer<EventMessage<?>> eventConsumer) {
        this.advanceTimeTo(this.currentDateTime.plus(duration), eventConsumer);
    }
}

