/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.matchers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public abstract class ListMatcher<T>
extends BaseMatcher<List<T>> {
    private final List<Matcher<? super T>> failedMatchers = new ArrayList<Matcher<? super T>>();
    private final Matcher<? super T>[] matchers;

    @SafeVarargs
    protected ListMatcher(Matcher<? super T> ... matchers) {
        this.matchers = matchers;
    }

    public boolean matches(Object item) {
        return List.class.isInstance(item) && this.matchesList((List)item);
    }

    protected abstract boolean matchesList(List<T> var1);

    protected boolean matchRemainder(Iterator<Matcher<? super T>> matcherIterator) {
        while (matcherIterator.hasNext()) {
            Matcher<? super T> matcher = matcherIterator.next();
            if (matcher.matches(null)) continue;
            this.failedMatchers.add(matcher);
            return false;
        }
        return true;
    }

    protected void reportFailed(Matcher<? super T> matcher) {
        this.failedMatchers.add(matcher);
    }

    protected List<Matcher<? super T>> getMatchers() {
        return Arrays.asList(this.matchers);
    }

    protected abstract void describeCollectionType(Description var1);

    public void describeTo(Description description) {
        description.appendText("list with ");
        this.describeCollectionType(description);
        description.appendText(" of: ");
        for (int t = 0; t < this.matchers.length; ++t) {
            if (t != 0 && t < this.matchers.length - 1) {
                description.appendText(", ");
            } else if (t == this.matchers.length - 1 && t > 0) {
                description.appendText(" ");
                description.appendText(this.getLastSeparator());
                description.appendText(" ");
            }
            description.appendText("<");
            this.matchers[t].describeTo(description);
            description.appendText(">");
            if (!this.failedMatchers.contains(this.matchers[t])) continue;
            description.appendText(" (");
            description.appendText(this.failedMatcherMessage());
            description.appendText(")");
        }
    }

    protected String failedMatcherMessage() {
        return "FAILED!";
    }

    protected String getLastSeparator() {
        return "and";
    }
}

