/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.aggregate;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.axonframework.commandhandling.AggregateAnnotationCommandHandler;
import org.axonframework.commandhandling.AnnotationCommandHandlerAdapter;
import org.axonframework.commandhandling.AnnotationCommandTargetResolver;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.CommandTargetResolver;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.model.Aggregate;
import org.axonframework.commandhandling.model.AggregateNotFoundException;
import org.axonframework.commandhandling.model.AggregateScopeDescriptor;
import org.axonframework.commandhandling.model.ConflictingAggregateVersionException;
import org.axonframework.commandhandling.model.Repository;
import org.axonframework.commandhandling.model.RepositoryProvider;
import org.axonframework.commandhandling.model.inspection.AggregateModel;
import org.axonframework.commandhandling.model.inspection.AnnotatedAggregate;
import org.axonframework.commandhandling.model.inspection.AnnotatedAggregateMetaModelFactory;
import org.axonframework.common.Assert;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.Registration;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.DomainEventMessage;
import org.axonframework.eventsourcing.EventSourcedAggregate;
import org.axonframework.eventsourcing.EventSourcingRepository;
import org.axonframework.eventsourcing.GenericAggregateFactory;
import org.axonframework.eventsourcing.GenericDomainEventMessage;
import org.axonframework.eventsourcing.NoSnapshotTriggerDefinition;
import org.axonframework.eventsourcing.SnapshotTriggerDefinition;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.EventStoreException;
import org.axonframework.eventsourcing.eventstore.TrackingEventStream;
import org.axonframework.eventsourcing.eventstore.TrackingToken;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MultiParameterResolverFactory;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.annotation.SimpleResourceParameterResolverFactory;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.test.AxonAssertionError;
import org.axonframework.test.FixtureExecutionException;
import org.axonframework.test.aggregate.FixtureConfiguration;
import org.axonframework.test.aggregate.ResultValidator;
import org.axonframework.test.aggregate.ResultValidatorImpl;
import org.axonframework.test.aggregate.TestExecutor;
import org.axonframework.test.deadline.StubDeadlineManager;
import org.axonframework.test.matchers.FieldFilter;
import org.axonframework.test.matchers.IgnoreField;
import org.axonframework.test.matchers.MatchAllFieldFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateTestFixture<T>
implements FixtureConfiguration<T>,
TestExecutor<T> {
    private static final Logger logger = LoggerFactory.getLogger(AggregateTestFixture.class);
    private final Class<T> aggregateType;
    private final SimpleCommandBus commandBus;
    private final List<MessageDispatchInterceptor<CommandMessage<?>>> commandDispatchInterceptors = new ArrayList();
    private final List<MessageHandlerInterceptor<CommandMessage<?>>> commandHandlerInterceptors = new ArrayList();
    private final EventStore eventStore;
    private final List<FieldFilter> fieldFilters = new ArrayList<FieldFilter>();
    private final List<Object> resources = new ArrayList<Object>();
    private RepositoryProvider repositoryProvider;
    private IdentifierValidatingRepository<T> repository;
    private StubDeadlineManager deadlineManager = new StubDeadlineManager();
    private String aggregateIdentifier;
    private Deque<DomainEventMessage<?>> givenEvents;
    private Deque<DomainEventMessage<?>> storedEvents;
    private List<EventMessage<?>> publishedEvents;
    private long sequenceNumber = 0L;
    private boolean reportIllegalStateChange = true;
    private boolean explicitCommandHandlersSet;
    private MultiParameterResolverFactory parameterResolverFactory;
    private HandlerDefinition handlerDefinition;

    public AggregateTestFixture(Class<T> aggregateType) {
        this.commandBus = SimpleCommandBus.builder().build();
        this.eventStore = new RecordingEventStore();
        this.resources.add(this.commandBus);
        this.resources.add(this.eventStore);
        this.resources.add(this.deadlineManager);
        this.aggregateType = aggregateType;
        this.clearGivenWhenState();
        this.parameterResolverFactory = MultiParameterResolverFactory.ordered((ParameterResolverFactory[])new ParameterResolverFactory[]{new SimpleResourceParameterResolverFactory(this.resources), ClasspathParameterResolverFactory.forClass(aggregateType)});
        this.handlerDefinition = ClasspathHandlerDefinition.forClass(aggregateType);
    }

    @Override
    public FixtureConfiguration<T> registerRepository(Repository<T> repository) {
        this.repository = new IdentifierValidatingRepository<T>(repository);
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerRepositoryProvider(RepositoryProvider repositoryProvider) {
        this.repositoryProvider = repositoryProvider;
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerAggregateFactory(AggregateFactory<T> aggregateFactory) {
        MultiParameterResolverFactory parameterResolverFactory = MultiParameterResolverFactory.ordered((ParameterResolverFactory[])new ParameterResolverFactory[]{new SimpleResourceParameterResolverFactory(this.resources), ClasspathParameterResolverFactory.forClass(this.aggregateType)});
        return this.registerRepository((Repository<T>)new EventSourcingRepository(aggregateFactory, this.eventStore, (ParameterResolverFactory)parameterResolverFactory, this.handlerDefinition, (SnapshotTriggerDefinition)NoSnapshotTriggerDefinition.INSTANCE, this.getRepositoryProvider()));
    }

    @Override
    public synchronized FixtureConfiguration<T> registerAnnotatedCommandHandler(Object annotatedCommandHandler) {
        this.registerAggregateCommandHandlers();
        this.explicitCommandHandlersSet = true;
        AnnotationCommandHandlerAdapter adapter = new AnnotationCommandHandlerAdapter(annotatedCommandHandler, (ParameterResolverFactory)this.parameterResolverFactory, this.handlerDefinition);
        adapter.subscribe((CommandBus)this.commandBus);
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerCommandHandler(Class<?> payloadType, MessageHandler<CommandMessage<?>> commandHandler) {
        return this.registerCommandHandler(payloadType.getName(), commandHandler);
    }

    @Override
    public FixtureConfiguration<T> registerCommandHandler(String commandName, MessageHandler<CommandMessage<?>> commandHandler) {
        this.registerAggregateCommandHandlers();
        this.explicitCommandHandlersSet = true;
        this.commandBus.subscribe(commandName, commandHandler);
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerInjectableResource(Object resource) {
        if (this.explicitCommandHandlersSet) {
            throw new FixtureExecutionException("Cannot inject resources after command handler has been created. Configure all resource before calling registerCommandHandler() or registerAnnotatedCommandHandler()");
        }
        this.resources.add(resource);
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerCommandDispatchInterceptor(MessageDispatchInterceptor<CommandMessage<?>> commandDispatchInterceptor) {
        this.commandDispatchInterceptors.add(commandDispatchInterceptor);
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerCommandHandlerInterceptor(MessageHandlerInterceptor<CommandMessage<?>> commandHandlerInterceptor) {
        this.commandHandlerInterceptors.add(commandHandlerInterceptor);
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerFieldFilter(FieldFilter fieldFilter) {
        this.fieldFilters.add(fieldFilter);
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerIgnoredField(Class<?> declaringClass, String fieldName) {
        return this.registerFieldFilter(new IgnoreField(declaringClass, fieldName));
    }

    @Override
    public FixtureConfiguration<T> registerHandlerDefinition(HandlerDefinition handlerDefinition) {
        this.handlerDefinition = handlerDefinition;
        return this;
    }

    @Override
    public TestExecutor<T> given(Object ... domainEvents) {
        return this.given(Arrays.asList(domainEvents));
    }

    @Override
    public TestExecutor<T> andGiven(Object ... domainEvents) {
        return this.andGiven(Arrays.asList(domainEvents));
    }

    @Override
    public TestExecutor<T> givenNoPriorActivity() {
        return this.given(Collections.emptyList());
    }

    @Override
    public TestExecutor<T> givenState(Supplier<T> aggregate) {
        this.clearGivenWhenState();
        DefaultUnitOfWork.startAndGet(null).execute(() -> {
            if (this.repository == null) {
                this.registerRepository(new InMemoryRepository<T>(this.aggregateType, (EventBus)this.eventStore, this.getRepositoryProvider()));
            }
            try {
                this.repository.newInstance(((Supplier)aggregate)::get);
            }
            catch (Exception e) {
                throw new FixtureExecutionException("An exception occurred while trying to initialize repository with given aggregate (using 'givenState')", e);
            }
        });
        return this;
    }

    @Override
    public TestExecutor<T> given(List<?> domainEvents) {
        this.ensureRepositoryConfiguration();
        this.clearGivenWhenState();
        return this.andGiven(domainEvents);
    }

    @Override
    public TestExecutor<T> andGiven(List<?> domainEvents) {
        Iterator<?> iterator = domainEvents.iterator();
        while (iterator.hasNext()) {
            Object event;
            Object payload = event = iterator.next();
            MetaData metaData = null;
            if (event instanceof Message) {
                payload = ((Message)event).getPayload();
                metaData = ((Message)event).getMetaData();
            }
            this.givenEvents.add((DomainEventMessage<?>)new GenericDomainEventMessage(this.aggregateType.getSimpleName(), this.aggregateIdentifier, this.sequenceNumber++, payload, (Map)metaData));
        }
        return this;
    }

    @Override
    public TestExecutor<T> givenCommands(Object ... commands) {
        return this.givenCommands(Arrays.asList(commands));
    }

    @Override
    public TestExecutor<T> andGivenCommands(Object ... commands) {
        return this.andGivenCommands(Arrays.asList(commands));
    }

    @Override
    public TestExecutor<T> givenCommands(List<?> commands) {
        this.clearGivenWhenState();
        return this.andGivenCommands(commands);
    }

    @Override
    public TestExecutor<T> andGivenCommands(List<?> commands) {
        this.finalizeConfiguration();
        for (Object command : commands) {
            ExecutionExceptionAwareCallback callback = new ExecutionExceptionAwareCallback();
            this.commandBus.dispatch(GenericCommandMessage.asCommandMessage(command), (CommandCallback)callback);
            callback.assertSuccessful();
            this.givenEvents.addAll(this.storedEvents);
            this.storedEvents.clear();
        }
        this.publishedEvents.clear();
        return this;
    }

    @Override
    public TestExecutor<T> andGivenCurrentTime(Instant currentTime) {
        this.deadlineManager.initializeAt(currentTime);
        return this;
    }

    @Override
    public Instant currentTime() {
        return this.deadlineManager.getCurrentDateTime();
    }

    @Override
    public ResultValidator andThenTimeElapses(Duration elapsedTime) {
        this.deadlineManager.advanceTimeBy(elapsedTime, this::handleDeadline);
        return this.buildResultValidator();
    }

    @Override
    public ResultValidator andThenTimeAdvancesTo(Instant newDateTime) {
        this.deadlineManager.advanceTimeTo(newDateTime, this::handleDeadline);
        return this.buildResultValidator();
    }

    @Override
    public ResultValidator<T> when(Object command) {
        return this.when(command, (Map<String, ?>)MetaData.emptyInstance());
    }

    @Override
    public ResultValidator<T> when(Object command, Map<String, ?> metaData) {
        this.finalizeConfiguration();
        MatchAllFieldFilter fieldFilter = new MatchAllFieldFilter(this.fieldFilters);
        ResultValidatorImpl resultValidator = new ResultValidatorImpl(this.publishedEvents, fieldFilter, () -> this.repository.getAggregate(), this.deadlineManager);
        this.commandBus.dispatch(GenericCommandMessage.asCommandMessage((Object)command).andMetaData(metaData), resultValidator);
        if (!((IdentifierValidatingRepository)this.repository).rolledBack) {
            Aggregate workingAggregate = ((IdentifierValidatingRepository)this.repository).aggregate;
            this.detectIllegalStateChanges(fieldFilter, workingAggregate);
        }
        resultValidator.assertValidRecording();
        return resultValidator;
    }

    protected void handleDeadline(ScopeDescriptor aggregateDescriptor, DeadlineMessage<?> deadlineMessage) {
        this.ensureRepositoryConfiguration();
        DefaultUnitOfWork.startAndGet(deadlineMessage).execute(() -> {
            try {
                this.repository.send((Message<?>)deadlineMessage, aggregateDescriptor);
            }
            catch (Exception e) {
                throw new FixtureExecutionException("Exception occurred while handling the deadline", e);
            }
        });
    }

    private ResultValidator buildResultValidator() {
        MatchAllFieldFilter fieldFilter = new MatchAllFieldFilter(this.fieldFilters);
        ResultValidatorImpl resultValidator = new ResultValidatorImpl(this.publishedEvents, fieldFilter, () -> this.repository.getAggregate(), this.deadlineManager);
        resultValidator.assertValidRecording();
        return resultValidator;
    }

    private void ensureRepositoryConfiguration() {
        if (this.repository == null) {
            this.registerRepository((Repository<T>)new EventSourcingRepository((AggregateFactory)new GenericAggregateFactory(this.aggregateType), this.eventStore, (ParameterResolverFactory)this.parameterResolverFactory, this.handlerDefinition, (SnapshotTriggerDefinition)NoSnapshotTriggerDefinition.INSTANCE, this.getRepositoryProvider()));
        }
    }

    private RepositoryProvider getRepositoryProvider() {
        if (this.repositoryProvider == null) {
            this.registerRepositoryProvider(new DefaultRepositoryProvider());
        }
        return this.repositoryProvider;
    }

    private void finalizeConfiguration() {
        this.registerAggregateCommandHandlers();
        this.registerCommandInterceptors();
        this.explicitCommandHandlersSet = true;
    }

    private void registerAggregateCommandHandlers() {
        this.ensureRepositoryConfiguration();
        if (!this.explicitCommandHandlersSet) {
            AggregateAnnotationCommandHandler handler = new AggregateAnnotationCommandHandler(this.aggregateType, this.repository, (CommandTargetResolver)new AnnotationCommandTargetResolver(), (ParameterResolverFactory)this.parameterResolverFactory);
            handler.subscribe((CommandBus)this.commandBus);
        }
    }

    private void registerCommandInterceptors() {
        this.commandDispatchInterceptors.forEach(arg_0 -> ((SimpleCommandBus)this.commandBus).registerDispatchInterceptor(arg_0));
        this.commandHandlerInterceptors.forEach(arg_0 -> ((SimpleCommandBus)this.commandBus).registerHandlerInterceptor(arg_0));
    }

    private void detectIllegalStateChanges(MatchAllFieldFilter fieldFilter, Aggregate<T> workingAggregate) {
        logger.debug("Starting separate Unit of Work for the purpose of checking illegal state changes in Aggregate");
        if (this.aggregateIdentifier != null && workingAggregate != null && this.reportIllegalStateChange) {
            DefaultUnitOfWork uow = DefaultUnitOfWork.startAndGet(null);
            try {
                Aggregate aggregate2 = ((IdentifierValidatingRepository)this.repository).delegate.load(this.aggregateIdentifier);
                if (workingAggregate.isDeleted()) {
                    throw new AxonAssertionError("The working aggregate was considered deleted, but the Repository still contains a non-deleted copy of the aggregate. Make sure the aggregate explicitly marks itself as deleted in an EventHandler.");
                }
                this.assertValidWorkingAggregateState(aggregate2, fieldFilter, workingAggregate);
            }
            catch (AggregateNotFoundException notFound) {
                if (!workingAggregate.isDeleted()) {
                    throw new AxonAssertionError("The working aggregate was not considered deleted, but the Repository cannot recover the state of the aggregate, as it is considered deleted there.");
                }
            }
            catch (Exception e) {
                throw new FixtureExecutionException("An Exception occurred while reconstructing the Aggregate from given and published events. This may be an indication that the aggregate cannot be recreated from its events.", e);
            }
            finally {
                uow.rollback();
            }
        }
    }

    private void assertValidWorkingAggregateState(Aggregate<T> eventSourcedAggregate, MatchAllFieldFilter fieldFilter, Aggregate<T> workingAggregate) {
        HashSet<ComparationEntry> comparedEntries = new HashSet<ComparationEntry>();
        if (!workingAggregate.rootType().equals(eventSourcedAggregate.rootType())) {
            throw new AxonAssertionError(String.format("The aggregate loaded based on the generated events seems to be of another type than the original.\nWorking type: <%s>\nEvent Sourced type: <%s>", workingAggregate.rootType().getName(), eventSourcedAggregate.rootType().getName()));
        }
        this.ensureValuesEqual(workingAggregate.invoke(Function.identity()), eventSourcedAggregate.invoke(Function.identity()), eventSourcedAggregate.rootType().getName(), comparedEntries, fieldFilter);
    }

    private void ensureValuesEqual(Object workingValue, Object eventSourcedValue, String propertyPath, Set<ComparationEntry> comparedEntries, FieldFilter fieldFilter) {
        if (ReflectionUtils.explicitlyUnequal((Object)workingValue, (Object)eventSourcedValue)) {
            throw new AxonAssertionError(String.format("Illegal state change detected! Property \"%s\" has different value when sourcing events.\nWorking aggregate value:     <%s>\nValue after applying events: <%s>", propertyPath, workingValue, eventSourcedValue));
        }
        if (workingValue != null && comparedEntries.add(new ComparationEntry(workingValue, eventSourcedValue)) && !ReflectionUtils.hasEqualsMethod(workingValue.getClass())) {
            for (Field field : ReflectionUtils.fieldsOf(workingValue.getClass())) {
                if (!fieldFilter.accept(field) || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                ReflectionUtils.ensureAccessible((AccessibleObject)field);
                String newPropertyPath = propertyPath + "." + field.getName();
                Object workingFieldValue = ReflectionUtils.getFieldValue((Field)field, (Object)workingValue);
                Object eventSourcedFieldValue = ReflectionUtils.getFieldValue((Field)field, (Object)eventSourcedValue);
                this.ensureValuesEqual(workingFieldValue, eventSourcedFieldValue, newPropertyPath, comparedEntries, fieldFilter);
            }
        }
    }

    private void clearGivenWhenState() {
        this.storedEvents = new LinkedList();
        this.publishedEvents = new ArrayList();
        this.givenEvents = new LinkedList();
        this.sequenceNumber = 0L;
    }

    @Override
    public void setReportIllegalStateChange(boolean reportIllegalStateChange) {
        this.reportIllegalStateChange = reportIllegalStateChange;
    }

    @Override
    public CommandBus getCommandBus() {
        return this.commandBus;
    }

    @Override
    public EventBus getEventBus() {
        return this.eventStore;
    }

    @Override
    public EventStore getEventStore() {
        return this.eventStore;
    }

    @Override
    public Repository<T> getRepository() {
        this.ensureRepositoryConfiguration();
        return this.repository;
    }

    private class CreationalRepository<R>
    implements Repository<R> {
        private final Class<R> aggregateType;
        private final RepositoryProvider repositoryProvider;

        private CreationalRepository(Class<R> aggregateType, RepositoryProvider repositoryProvider) {
            this.aggregateType = aggregateType;
            this.repositoryProvider = repositoryProvider;
        }

        public Aggregate<R> load(String aggregateIdentifier) {
            throw new UnsupportedOperationException("Default repository does not mock loading of an aggregate, only creation of it");
        }

        public Aggregate<R> load(String aggregateIdentifier, Long expectedVersion) {
            throw new UnsupportedOperationException("Default repository does not mock loading of an aggregate, only creation of it");
        }

        public Aggregate<R> newInstance(Callable<R> factoryMethod) throws Exception {
            AggregateModel aggregateModel = AnnotatedAggregateMetaModelFactory.inspectAggregate(this.aggregateType);
            return EventSourcedAggregate.initialize(factoryMethod, (AggregateModel)aggregateModel, (EventBus)AggregateTestFixture.this.eventStore, (RepositoryProvider)this.repositoryProvider);
        }

        public void send(Message<?> message, ScopeDescriptor scopeDescription) {
            throw new UnsupportedOperationException("Default repository does not mock loading of an aggregate, only creation of it");
        }

        public boolean canResolve(ScopeDescriptor scopeDescription) {
            return false;
        }
    }

    private class DefaultRepositoryProvider
    implements RepositoryProvider {
        private DefaultRepositoryProvider() {
        }

        public <R> Repository<R> repositoryFor(Class<R> aggregateType) {
            return new CreationalRepository(aggregateType, this);
        }
    }

    private class ExecutionExceptionAwareCallback
    implements CommandCallback<Object, Object> {
        private FixtureExecutionException exception;

        private ExecutionExceptionAwareCallback() {
        }

        public void onSuccess(CommandMessage<?> commandMessage, CommandResultMessage<?> commandResultMessage) {
        }

        public void onFailure(CommandMessage<?> commandMessage, Throwable cause) {
            this.exception = cause instanceof FixtureExecutionException ? (FixtureExecutionException)((Object)cause) : new FixtureExecutionException("Failed to execute givenCommands", cause);
        }

        public void assertSuccessful() {
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }

    private class RecordingEventStore
    implements EventStore {
        private RecordingEventStore() {
        }

        public DomainEventStream readEvents(String identifier) {
            if (AggregateTestFixture.this.aggregateIdentifier != null && !AggregateTestFixture.this.aggregateIdentifier.equals(identifier)) {
                throw new EventStoreException("You probably want to use aggregateIdentifier() on your fixture to get the aggregate identifier to use");
            }
            if (AggregateTestFixture.this.aggregateIdentifier == null) {
                AggregateTestFixture.this.aggregateIdentifier = identifier;
                this.injectAggregateIdentifier();
            }
            ArrayList allEvents = new ArrayList(AggregateTestFixture.this.givenEvents);
            allEvents.addAll(AggregateTestFixture.this.storedEvents);
            if (allEvents.isEmpty()) {
                throw new AggregateNotFoundException(identifier, "No 'given' events were configured for this aggregate, nor have any events been stored.");
            }
            return DomainEventStream.of(allEvents);
        }

        public void publish(List<? extends EventMessage<?>> events) {
            if (CurrentUnitOfWork.isStarted()) {
                CurrentUnitOfWork.get().onPrepareCommit(u -> this.doAppendEvents(events));
            } else {
                this.doAppendEvents(events);
            }
        }

        protected void doAppendEvents(List<? extends EventMessage<?>> events) {
            AggregateTestFixture.this.publishedEvents.addAll(events);
            events.stream().filter(DomainEventMessage.class::isInstance).map(e -> (DomainEventMessage)e).forEach(event -> {
                DomainEventMessage lastEvent;
                if (AggregateTestFixture.this.aggregateIdentifier == null) {
                    AggregateTestFixture.this.aggregateIdentifier = event.getAggregateIdentifier();
                    this.injectAggregateIdentifier();
                }
                if ((lastEvent = (DomainEventMessage)(AggregateTestFixture.this.storedEvents.isEmpty() ? AggregateTestFixture.this.givenEvents : AggregateTestFixture.this.storedEvents).peekLast()) != null) {
                    if (!lastEvent.getAggregateIdentifier().equals(event.getAggregateIdentifier())) {
                        throw new EventStoreException("Writing events for an unexpected aggregate. This could indicate that a wrong aggregate is being triggered.");
                    }
                    if (lastEvent.getSequenceNumber() != event.getSequenceNumber() - 1L) {
                        throw new EventStoreException(String.format("Unexpected sequence number on stored event. Expected %s, but got %s.", lastEvent.getSequenceNumber() + 1L, event.getSequenceNumber()));
                    }
                }
                AggregateTestFixture.this.storedEvents.add(event);
            });
        }

        private void injectAggregateIdentifier() {
            ArrayList oldEvents = new ArrayList(AggregateTestFixture.this.givenEvents);
            AggregateTestFixture.this.givenEvents.clear();
            for (DomainEventMessage oldEvent : oldEvents) {
                if (oldEvent.getAggregateIdentifier() == null) {
                    AggregateTestFixture.this.givenEvents.add(new GenericDomainEventMessage(oldEvent.getType(), AggregateTestFixture.this.aggregateIdentifier, oldEvent.getSequenceNumber(), oldEvent.getPayload(), (Map)oldEvent.getMetaData(), oldEvent.getIdentifier(), oldEvent.getTimestamp()));
                    continue;
                }
                AggregateTestFixture.this.givenEvents.add(oldEvent);
            }
        }

        public TrackingEventStream openStream(TrackingToken trackingToken) {
            throw new UnsupportedOperationException();
        }

        public void storeSnapshot(DomainEventMessage<?> snapshot) {
        }

        public Registration subscribe(Consumer<List<? extends EventMessage<?>>> eventProcessor) {
            return () -> true;
        }

        public Registration registerDispatchInterceptor(MessageDispatchInterceptor<? super EventMessage<?>> dispatchInterceptor) {
            return () -> true;
        }
    }

    private static class InMemoryRepository<T>
    implements Repository<T> {
        private final EventBus eventBus;
        private final RepositoryProvider repositoryProvider;
        private final AggregateModel<T> aggregateModel;
        private AnnotatedAggregate<T> storedAggregate;

        protected InMemoryRepository(Class<T> aggregateType, EventBus eventBus, RepositoryProvider repositoryProvider) {
            this.aggregateModel = AnnotatedAggregateMetaModelFactory.inspectAggregate(aggregateType);
            this.eventBus = eventBus;
            this.repositoryProvider = repositoryProvider;
        }

        public Aggregate<T> newInstance(Callable<T> factoryMethod) throws Exception {
            Assert.state((this.storedAggregate == null ? 1 : 0) != 0, () -> "Creating an Aggregate while one is already stored. Test fixtures do not allow multiple instances to be stored.");
            this.storedAggregate = AnnotatedAggregate.initialize(factoryMethod, this.aggregateModel, (EventBus)this.eventBus, (RepositoryProvider)this.repositoryProvider, (boolean)true);
            return this.storedAggregate;
        }

        public Aggregate<T> load(String aggregateIdentifier) {
            return this.load(aggregateIdentifier, null);
        }

        public Aggregate<T> load(String aggregateIdentifier, Long expectedVersion) {
            if (this.storedAggregate == null) {
                throw new AggregateNotFoundException(aggregateIdentifier, "Aggregate not found. No aggregate has been stored yet.");
            }
            if (!aggregateIdentifier.equals(this.storedAggregate.identifier().toString())) {
                throw new AggregateNotFoundException(aggregateIdentifier, "Aggregate not found. Did you mean to load " + this.storedAggregate.identifier() + "?");
            }
            if (this.storedAggregate.isDeleted()) {
                throw new AggregateNotFoundException(aggregateIdentifier, "Aggregate not found. It has been deleted.");
            }
            if (expectedVersion != null && !Objects.equals(expectedVersion, this.storedAggregate.version())) {
                throw new ConflictingAggregateVersionException(aggregateIdentifier, expectedVersion.longValue(), this.storedAggregate.version().longValue());
            }
            return this.storedAggregate;
        }

        public void send(Message<?> message, ScopeDescriptor scopeDescription) throws Exception {
            if (this.canResolve(scopeDescription)) {
                this.load(((AggregateScopeDescriptor)scopeDescription).getIdentifier().toString()).handle(message);
            }
        }

        public boolean canResolve(ScopeDescriptor scopeDescription) {
            return scopeDescription instanceof AggregateScopeDescriptor;
        }
    }

    private static class IdentifierValidatingRepository<T>
    implements Repository<T> {
        private final Repository<T> delegate;
        private Aggregate<T> aggregate;
        private boolean rolledBack;

        public IdentifierValidatingRepository(Repository<T> delegate) {
            this.delegate = delegate;
        }

        public Aggregate<T> newInstance(Callable<T> factoryMethod) throws Exception {
            CurrentUnitOfWork.get().onRollback(u -> {
                this.rolledBack = true;
            });
            this.aggregate = this.delegate.newInstance(factoryMethod);
            return this.aggregate;
        }

        public Aggregate<T> load(String aggregateIdentifier, Long expectedVersion) {
            CurrentUnitOfWork.get().onRollback(u -> {
                this.rolledBack = true;
            });
            this.aggregate = this.delegate.load(aggregateIdentifier, expectedVersion);
            this.validateIdentifier(aggregateIdentifier, this.aggregate);
            return this.aggregate;
        }

        public Aggregate<T> load(String aggregateIdentifier) {
            CurrentUnitOfWork.get().onRollback(u -> {
                this.rolledBack = true;
            });
            this.aggregate = this.delegate.load(aggregateIdentifier, null);
            this.validateIdentifier(aggregateIdentifier, this.aggregate);
            return this.aggregate;
        }

        private void validateIdentifier(String aggregateIdentifier, Aggregate<T> aggregate) {
            if (aggregateIdentifier != null && !aggregateIdentifier.equals(aggregate.identifierAsString())) {
                throw new AssertionError((Object)String.format("The aggregate used in this fixture was initialized with an identifier different than the one used to load it. Loaded [%s], but actual identifier is [%s].\nMake sure the identifier passed in the Command matches that of the given Events.", aggregateIdentifier, aggregate.identifierAsString()));
            }
        }

        public Aggregate<T> getAggregate() {
            Assert.state((!this.rolledBack ? 1 : 0) != 0, () -> "The state of this aggregate cannot be retrieved because it has been modified in a Unit of Work that was rolled back");
            return this.aggregate;
        }

        public void send(Message<?> message, ScopeDescriptor scopeDescription) throws Exception {
            if (this.canResolve(scopeDescription)) {
                this.load(((AggregateScopeDescriptor)scopeDescription).getIdentifier().toString()).handle(message);
            }
        }

        public boolean canResolve(ScopeDescriptor scopeDescription) {
            return scopeDescription instanceof AggregateScopeDescriptor;
        }
    }

    private static class ComparationEntry {
        private final Object workingObject;
        private final Object eventSourceObject;

        public ComparationEntry(Object workingObject, Object eventSourceObject) {
            this.workingObject = workingObject;
            this.eventSourceObject = eventSourceObject;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComparationEntry that = (ComparationEntry)o;
            return Objects.equals(this.workingObject, that.workingObject) && Objects.equals(this.eventSourceObject, that.eventSourceObject);
        }

        public int hashCode() {
            return Objects.hash(this.workingObject, this.eventSourceObject);
        }
    }
}

