/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.saga;

import java.util.Set;
import org.axonframework.saga.AssociationValue;
import org.axonframework.saga.annotation.AbstractAnnotatedSaga;
import org.axonframework.saga.repository.inmemory.InMemorySagaRepository;
import org.axonframework.test.AxonAssertionError;

public class RepositoryContentValidator {
    private final InMemorySagaRepository sagaRepository;
    private final Class<? extends AbstractAnnotatedSaga> sagaType;

    RepositoryContentValidator(InMemorySagaRepository sagaRepository, Class<? extends AbstractAnnotatedSaga> sagaType) {
        this.sagaRepository = sagaRepository;
        this.sagaType = sagaType;
    }

    public void assertAssociationPresent(String associationKey, String associationValue) {
        Set associatedSagas = this.sagaRepository.find(this.sagaType, new AssociationValue(associationKey, associationValue));
        if (associatedSagas.isEmpty()) {
            throw new AxonAssertionError(String.format("Expected a saga to be associated with key:<%s> value:<%s>, but found <none>", associationKey, associationValue));
        }
    }

    public void assertNoAssociationPresent(String associationKey, String associationValue) {
        Set associatedSagas = this.sagaRepository.find(this.sagaType, new AssociationValue(associationKey, associationValue));
        if (!associatedSagas.isEmpty()) {
            throw new AxonAssertionError(String.format("Expected a saga to be associated with key:<%s> value:<%s>, but found <%s>", associationKey, associationValue, associatedSagas.size()));
        }
    }

    public void assertActiveSagas(int expected) {
        if (expected != this.sagaRepository.size()) {
            throw new AxonAssertionError(String.format("Wrong number of active sagas. Expected <%s>, got <%s>.", expected, this.sagaRepository.size()));
        }
    }
}

