/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandHandlerInterceptor;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.InterceptorChain;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.annotation.AggregateAnnotationCommandHandler;
import org.axonframework.commandhandling.annotation.AnnotationCommandHandlerAdapter;
import org.axonframework.common.IdentifierValidator;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.domain.AggregateRoot;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.domain.DomainEventStream;
import org.axonframework.domain.EventMessage;
import org.axonframework.domain.GenericDomainEventMessage;
import org.axonframework.domain.Message;
import org.axonframework.domain.MetaData;
import org.axonframework.domain.SimpleDomainEventStream;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventListener;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.EventSourcedAggregateRoot;
import org.axonframework.eventsourcing.EventSourcingRepository;
import org.axonframework.eventstore.EventStore;
import org.axonframework.eventstore.EventStoreException;
import org.axonframework.repository.AggregateNotFoundException;
import org.axonframework.repository.Repository;
import org.axonframework.test.AxonAssertionError;
import org.axonframework.test.FixtureConfiguration;
import org.axonframework.test.FixtureExecutionException;
import org.axonframework.test.FixtureResourceParameterResolverFactory;
import org.axonframework.test.ResultValidator;
import org.axonframework.test.ResultValidatorImpl;
import org.axonframework.test.TestExecutor;
import org.axonframework.unitofwork.DefaultUnitOfWork;
import org.axonframework.unitofwork.UnitOfWork;
import org.axonframework.unitofwork.UnitOfWorkListener;
import org.axonframework.unitofwork.UnitOfWorkListenerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GivenWhenThenTestFixture<T extends EventSourcedAggregateRoot>
implements FixtureConfiguration<T>,
TestExecutor {
    private static final Logger logger = LoggerFactory.getLogger(GivenWhenThenTestFixture.class);
    private Repository<T> repository;
    private SimpleCommandBus commandBus;
    private EventBus eventBus;
    private Object aggregateIdentifier;
    private EventStore eventStore;
    private Collection<DomainEventMessage> givenEvents;
    private Deque<DomainEventMessage> storedEvents;
    private List<EventMessage> publishedEvents;
    private long sequenceNumber = 0L;
    private AggregateRoot workingAggregate;
    private boolean reportIllegalStateChange = true;
    private final Class<T> aggregateType;
    private boolean explicitCommandHandlersSet;
    private final List<Object> injectableResources = new ArrayList<Object>();

    public GivenWhenThenTestFixture(Class<T> aggregateType) {
        this.eventBus = new RecordingEventBus();
        this.commandBus = new SimpleCommandBus();
        this.eventStore = new RecordingEventStore();
        this.clearGivenWhenState();
        this.aggregateType = aggregateType;
    }

    @Override
    public FixtureConfiguration<T> registerRepository(EventSourcingRepository<T> eventSourcingRepository) {
        this.repository = new IdentifierValidatingRepository<T>(eventSourcingRepository);
        eventSourcingRepository.setEventBus(this.eventBus);
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerAggregateFactory(AggregateFactory<T> aggregateFactory) {
        return this.registerRepository(new EventSourcingRepository(aggregateFactory, this.eventStore));
    }

    @Override
    public synchronized FixtureConfiguration<T> registerAnnotatedCommandHandler(final Object annotatedCommandHandler) {
        this.registerAggregateCommandHandlers();
        this.explicitCommandHandlersSet = true;
        this.doWithInjectableResourcesAvailable(new Runnable(){

            @Override
            public void run() {
                AnnotationCommandHandlerAdapter.subscribe((Object)annotatedCommandHandler, (CommandBus)GivenWhenThenTestFixture.this.commandBus);
            }
        });
        return this;
    }

    @Override
    public FixtureConfiguration<T> registerCommandHandler(Class<?> payloadType, CommandHandler commandHandler) {
        return this.registerCommandHandler(payloadType.getName(), commandHandler);
    }

    @Override
    public FixtureConfiguration<T> registerCommandHandler(String commandName, CommandHandler commandHandler) {
        this.registerAggregateCommandHandlers();
        this.explicitCommandHandlersSet = true;
        this.commandBus.subscribe(commandName, commandHandler);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWithInjectableResourcesAvailable(Runnable runnable) {
        if (!this.injectableResources.contains(this.commandBus)) {
            this.injectableResources.add(this.commandBus);
        }
        if (!this.injectableResources.contains(this.eventBus)) {
            this.injectableResources.add(this.eventBus);
        }
        FixtureResourceParameterResolverFactory factory = FixtureResourceParameterResolverFactory.register(this.injectableResources);
        try {
            runnable.run();
        }
        finally {
            factory.disable();
        }
    }

    @Override
    public FixtureConfiguration<T> registerInjectableResource(Object resource) {
        if (this.explicitCommandHandlersSet) {
            throw new FixtureExecutionException("Cannot inject resources after command handler has been created. Configure all resource before calling registerCommandHandler() or registerAnnotatedCommandHandler()");
        }
        this.injectableResources.add(resource);
        return this;
    }

    @Override
    public TestExecutor given(Object ... domainEvents) {
        this.ensureRepositoryConfiguration();
        return this.given(Arrays.asList(domainEvents));
    }

    @Override
    public TestExecutor given(List<?> domainEvents) {
        this.clearGivenWhenState();
        Iterator<?> i$ = domainEvents.iterator();
        while (i$.hasNext()) {
            Object event;
            Object payload = event = i$.next();
            MetaData metaData = null;
            if (event instanceof Message) {
                payload = ((Message)event).getPayload();
                metaData = ((Message)event).getMetaData();
            }
            this.givenEvents.add((DomainEventMessage)new GenericDomainEventMessage(this.aggregateIdentifier, this.sequenceNumber++, payload, (Map)metaData));
        }
        return this;
    }

    @Override
    public TestExecutor givenCommands(Object ... commands) {
        return this.givenCommands(Arrays.asList(commands));
    }

    @Override
    public TestExecutor givenCommands(List<?> commands) {
        this.finalizeConfiguration();
        this.clearGivenWhenState();
        for (Object command : commands) {
            ExecutionExceptionAwareCallback callback = new ExecutionExceptionAwareCallback();
            this.commandBus.dispatch(GenericCommandMessage.asCommandMessage(command), (CommandCallback)callback);
            callback.assertSuccessful();
            this.givenEvents.addAll(this.storedEvents);
            this.storedEvents.clear();
        }
        this.publishedEvents.clear();
        return this;
    }

    @Override
    public ResultValidator when(Object command) {
        return this.when(command, (Map<String, ?>)MetaData.emptyInstance());
    }

    @Override
    public ResultValidator when(Object command, Map<String, ?> metaData) {
        this.finalizeConfiguration();
        ResultValidatorImpl resultValidator = new ResultValidatorImpl(this.storedEvents, this.publishedEvents);
        this.commandBus.setHandlerInterceptors(Collections.singletonList(new AggregateRegisteringInterceptor()));
        this.commandBus.dispatch(GenericCommandMessage.asCommandMessage((Object)command).andMetaData(metaData), (CommandCallback)resultValidator);
        this.detectIllegalStateChanges();
        resultValidator.assertValidRecording();
        return resultValidator;
    }

    private void ensureRepositoryConfiguration() {
        if (this.repository == null) {
            this.registerRepository(new EventSourcingRepository(this.aggregateType, this.eventStore));
        }
    }

    private void finalizeConfiguration() {
        this.ensureRepositoryConfiguration();
        this.registerAggregateCommandHandlers();
        this.explicitCommandHandlersSet = true;
    }

    private void registerAggregateCommandHandlers() {
        if (!this.explicitCommandHandlersSet) {
            this.doWithInjectableResourcesAvailable(new Runnable(){

                @Override
                public void run() {
                    new AggregateAnnotationCommandHandler(GivenWhenThenTestFixture.this.aggregateType, GivenWhenThenTestFixture.this.repository, (CommandBus)GivenWhenThenTestFixture.this.commandBus).subscribe();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detectIllegalStateChanges() {
        if (this.aggregateIdentifier != null && this.workingAggregate != null && this.reportIllegalStateChange) {
            UnitOfWork uow = DefaultUnitOfWork.startAndGet();
            try {
                EventSourcedAggregateRoot aggregate2 = (EventSourcedAggregateRoot)this.repository.load(this.aggregateIdentifier);
                if (this.workingAggregate.isDeleted()) {
                    throw new AxonAssertionError("The working aggregate was considered deleted, but the Repository still contains a non-deleted copy of the aggregate. Make sure one of the Aggregate's Events contains an AggregateDeletedEvent, or the aggregate explicitly marks itself as deleted in an EventHandler.");
                }
                this.assertValidWorkingAggregateState(aggregate2);
            }
            catch (AggregateNotFoundException notFound) {
                if (!this.workingAggregate.isDeleted()) {
                    throw new AxonAssertionError("The working aggregate was not considered deleted, but the Repository cannot recover the state of the aggregate, as it is considered deleted there.");
                }
            }
            catch (RuntimeException e) {
                logger.warn("An Exception occurred while detecting illegal state changes in {}.", (Object)this.workingAggregate.getClass().getName(), (Object)e);
            }
            finally {
                uow.rollback();
            }
        }
    }

    private void assertValidWorkingAggregateState(EventSourcedAggregateRoot eventSourcedAggregate) {
        HashSet<ComparationEntry> comparedEntries = new HashSet<ComparationEntry>();
        if (!this.workingAggregate.getClass().equals(eventSourcedAggregate.getClass())) {
            throw new AxonAssertionError(String.format("The aggregate loaded based on the generated events seems to be of another type than the original.\nWorking type: <%s>\nEvent Sourced type: <%s>", this.workingAggregate.getClass().getName(), eventSourcedAggregate.getClass().getName()));
        }
        this.ensureValuesEqual(this.workingAggregate, eventSourcedAggregate, eventSourcedAggregate.getClass().getName(), comparedEntries);
    }

    private void ensureValuesEqual(Object workingValue, Object eventSourcedValue, String propertyPath, Set<ComparationEntry> comparedEntries) {
        if (ReflectionUtils.explicitlyUnequal((Object)workingValue, (Object)eventSourcedValue)) {
            throw new AxonAssertionError(String.format("Illegal state change detected! Property \"%s\" has different value when sourcing events.\nWorking aggregate value:     <%s>\nValue after applying events: <%s>", propertyPath, workingValue, eventSourcedValue));
        }
        if (workingValue != null && comparedEntries.add(new ComparationEntry(workingValue, eventSourcedValue)) && !ReflectionUtils.hasEqualsMethod(workingValue.getClass())) {
            for (Field field : ReflectionUtils.fieldsOf(workingValue.getClass())) {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                ReflectionUtils.ensureAccessible((AccessibleObject)field);
                String newPropertyPath = propertyPath + "." + field.getName();
                try {
                    Object workingFieldValue = field.get(workingValue);
                    Object eventSourcedFieldValue = field.get(eventSourcedValue);
                    this.ensureValuesEqual(workingFieldValue, eventSourcedFieldValue, newPropertyPath, comparedEntries);
                }
                catch (IllegalAccessException e) {
                    logger.warn("Could not access field \"{}\". Unable to detect inappropriate state changes.", (Object)newPropertyPath);
                }
            }
        }
    }

    private void clearGivenWhenState() {
        this.storedEvents = new LinkedList<DomainEventMessage>();
        this.publishedEvents = new ArrayList<EventMessage>();
        this.givenEvents = new ArrayList<DomainEventMessage>();
        this.sequenceNumber = 0L;
    }

    @Override
    public void setReportIllegalStateChange(boolean reportIllegalStateChange) {
        this.reportIllegalStateChange = reportIllegalStateChange;
    }

    @Override
    public CommandBus getCommandBus() {
        return this.commandBus;
    }

    @Override
    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public EventStore getEventStore() {
        return this.eventStore;
    }

    @Override
    public Repository<T> getRepository() {
        this.ensureRepositoryConfiguration();
        return this.repository;
    }

    private class ExecutionExceptionAwareCallback
    implements CommandCallback<Object> {
        private FixtureExecutionException exception;

        private ExecutionExceptionAwareCallback() {
        }

        public void onSuccess(Object result) {
        }

        public void onFailure(Throwable cause) {
            if (cause instanceof FixtureExecutionException) {
                this.exception = (FixtureExecutionException)((Object)cause);
            }
        }

        public void assertSuccessful() {
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }

    private static class IdentifierValidatingRepository<T extends AggregateRoot>
    implements Repository<T> {
        private final Repository<T> delegate;

        public IdentifierValidatingRepository(Repository<T> delegate) {
            this.delegate = delegate;
        }

        public T load(Object aggregateIdentifier, Long expectedVersion) {
            AggregateRoot aggregate = (AggregateRoot)this.delegate.load(aggregateIdentifier, expectedVersion);
            this.validateIdentifier(aggregateIdentifier, aggregate);
            return (T)aggregate;
        }

        public T load(Object aggregateIdentifier) {
            AggregateRoot aggregate = (AggregateRoot)this.delegate.load(aggregateIdentifier, null);
            this.validateIdentifier(aggregateIdentifier, aggregate);
            return (T)aggregate;
        }

        private void validateIdentifier(Object aggregateIdentifier, T aggregate) {
            if (aggregateIdentifier != null && !aggregateIdentifier.equals(aggregate.getIdentifier())) {
                throw new AssertionError((Object)String.format("The aggregate used in this fixture was initialized with an identifier different than the one used to load it. Loaded [%s], but actual identifier is [%s].\nMake sure the identifier passed in the Command matches that of the given Events.", aggregateIdentifier, aggregate.getIdentifier()));
            }
        }

        public void add(T aggregate) {
            this.delegate.add(aggregate);
        }
    }

    private static class ComparationEntry {
        private final Object workingObject;
        private final Object eventSourceObject;

        public ComparationEntry(Object workingObject, Object eventSourceObject) {
            this.workingObject = workingObject;
            this.eventSourceObject = eventSourceObject;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComparationEntry that = (ComparationEntry)o;
            if (!this.eventSourceObject.equals(that.eventSourceObject)) {
                return false;
            }
            return this.workingObject.equals(that.workingObject);
        }

        public int hashCode() {
            int result = this.workingObject.hashCode();
            result = 31 * result + this.eventSourceObject.hashCode();
            return result;
        }
    }

    private class AggregateRegisteringInterceptor
    implements CommandHandlerInterceptor {
        private AggregateRegisteringInterceptor() {
        }

        public Object handle(CommandMessage<?> commandMessage, UnitOfWork unitOfWork, InterceptorChain interceptorChain) throws Throwable {
            unitOfWork.registerListener((UnitOfWorkListener)new UnitOfWorkListenerAdapter(){

                public void onPrepareCommit(UnitOfWork unitOfWork, Set<AggregateRoot> aggregateRoots, List<EventMessage> events) {
                    Iterator<AggregateRoot> iterator = aggregateRoots.iterator();
                    if (iterator.hasNext()) {
                        GivenWhenThenTestFixture.this.workingAggregate = iterator.next();
                    }
                }
            });
            return interceptorChain.proceed();
        }
    }

    private class RecordingEventBus
    implements EventBus {
        private RecordingEventBus() {
        }

        public void publish(EventMessage ... events) {
            GivenWhenThenTestFixture.this.publishedEvents.addAll(Arrays.asList(events));
        }

        public void subscribe(EventListener eventListener) {
        }

        public void unsubscribe(EventListener eventListener) {
        }
    }

    private class RecordingEventStore
    implements EventStore {
        private RecordingEventStore() {
        }

        public void appendEvents(String type, DomainEventStream events) {
            while (events.hasNext()) {
                DomainEventMessage next = events.next();
                IdentifierValidator.validateIdentifier(next.getAggregateIdentifier().getClass());
                if (!GivenWhenThenTestFixture.this.storedEvents.isEmpty()) {
                    DomainEventMessage lastEvent = (DomainEventMessage)GivenWhenThenTestFixture.this.storedEvents.peekLast();
                    if (!lastEvent.getAggregateIdentifier().equals(next.getAggregateIdentifier())) {
                        throw new EventStoreException("Writing events for an unexpected aggregate. This could indicate that a wrong aggregate is being triggered.");
                    }
                    if (lastEvent.getSequenceNumber() != next.getSequenceNumber() - 1L) {
                        throw new EventStoreException(String.format("Unexpected sequence number on stored event. Expected %s, but got %s.", lastEvent.getSequenceNumber() + 1L, next.getSequenceNumber()));
                    }
                }
                if (GivenWhenThenTestFixture.this.aggregateIdentifier == null) {
                    GivenWhenThenTestFixture.this.aggregateIdentifier = next.getAggregateIdentifier();
                    this.injectAggregateIdentifier();
                }
                GivenWhenThenTestFixture.this.storedEvents.add(next);
            }
        }

        public DomainEventStream readEvents(String type, Object identifier) {
            if (identifier != null) {
                IdentifierValidator.validateIdentifier(identifier.getClass());
            }
            if (GivenWhenThenTestFixture.this.aggregateIdentifier != null && !GivenWhenThenTestFixture.this.aggregateIdentifier.equals(identifier)) {
                throw new EventStoreException("You probably want to use aggregateIdentifier() on your fixture to get the aggregate identifier to use");
            }
            if (GivenWhenThenTestFixture.this.aggregateIdentifier == null) {
                GivenWhenThenTestFixture.this.aggregateIdentifier = identifier;
                this.injectAggregateIdentifier();
            }
            ArrayList allEvents = new ArrayList(GivenWhenThenTestFixture.this.givenEvents);
            allEvents.addAll(GivenWhenThenTestFixture.this.storedEvents);
            if (allEvents.isEmpty()) {
                throw new AggregateNotFoundException(identifier, "No 'given' events were configured for this aggregate, nor have any events been stored.");
            }
            return new SimpleDomainEventStream(allEvents);
        }

        private void injectAggregateIdentifier() {
            ArrayList oldEvents = new ArrayList(GivenWhenThenTestFixture.this.givenEvents);
            GivenWhenThenTestFixture.this.givenEvents.clear();
            for (DomainEventMessage oldEvent : oldEvents) {
                if (oldEvent.getAggregateIdentifier() == null) {
                    GivenWhenThenTestFixture.this.givenEvents.add(new GenericDomainEventMessage(oldEvent.getIdentifier(), oldEvent.getTimestamp(), GivenWhenThenTestFixture.this.aggregateIdentifier, oldEvent.getSequenceNumber(), oldEvent.getPayload(), (Map)oldEvent.getMetaData()));
                    continue;
                }
                GivenWhenThenTestFixture.this.givenEvents.add(oldEvent);
            }
        }
    }
}

