/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.matchers;

import java.util.List;
import org.axonframework.domain.Event;
import org.axonframework.test.matchers.EqualEventMatcher;
import org.axonframework.test.matchers.ExactSequenceMatcher;
import org.axonframework.test.matchers.ListWithAllOfMatcher;
import org.axonframework.test.matchers.ListWithAnyOfMatcher;
import org.axonframework.test.matchers.NoCommandsMatcher;
import org.axonframework.test.matchers.NoEventsMatcher;
import org.axonframework.test.matchers.NullOrVoidMatcher;
import org.axonframework.test.matchers.SequenceMatcher;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public abstract class Matchers {
    private Matchers() {
    }

    @Factory
    public static <T> ListWithAllOfMatcher listWithAllOf(Matcher<T> ... matchers) {
        return new ListWithAllOfMatcher<T>(matchers);
    }

    @Factory
    public static <T> ListWithAnyOfMatcher<T> listWithAnyOf(Matcher<T> ... matchers) {
        return new ListWithAnyOfMatcher<T>(matchers);
    }

    @Factory
    public static <T> SequenceMatcher<T> sequenceOf(Matcher<? extends T> ... matchers) {
        return new SequenceMatcher<T>(matchers);
    }

    @Factory
    public static <T> ExactSequenceMatcher<T> exactSequenceOf(Matcher<? extends T> ... matchers) {
        return new ExactSequenceMatcher<T>(matchers);
    }

    @Factory
    public static Matcher<List<? extends Event>> noEvents() {
        return new NoEventsMatcher();
    }

    @Factory
    public static Matcher<List<?>> noCommands() {
        return new NoCommandsMatcher();
    }

    @Factory
    public static <T extends Event> EqualEventMatcher<T> equalTo(T expected) {
        return new EqualEventMatcher<T>(expected);
    }

    @Factory
    public static NullOrVoidMatcher andNoMore() {
        return Matchers.nothing();
    }

    @Factory
    public static NullOrVoidMatcher nothing() {
        return new NullOrVoidMatcher();
    }
}

