/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test;

import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandHandlerInterceptor;
import org.axonframework.commandhandling.InterceptorChain;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.annotation.AnnotationCommandHandlerAdapter;
import org.axonframework.domain.AggregateIdentifier;
import org.axonframework.domain.AggregateRoot;
import org.axonframework.domain.DomainEvent;
import org.axonframework.domain.DomainEventStream;
import org.axonframework.domain.Event;
import org.axonframework.domain.SimpleDomainEventStream;
import org.axonframework.domain.UUIDAggregateIdentifier;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventListener;
import org.axonframework.eventsourcing.EventSourcedAggregateRoot;
import org.axonframework.eventsourcing.EventSourcingRepository;
import org.axonframework.eventsourcing.GenericEventSourcingRepository;
import org.axonframework.eventstore.EventStore;
import org.axonframework.eventstore.EventStoreException;
import org.axonframework.monitoring.jmx.JmxConfiguration;
import org.axonframework.repository.AggregateNotFoundException;
import org.axonframework.test.AxonAssertionError;
import org.axonframework.test.FixtureConfiguration;
import org.axonframework.test.FixtureExecutionException;
import org.axonframework.test.ResultValidator;
import org.axonframework.test.ResultValidatorImpl;
import org.axonframework.test.TestExecutor;
import org.axonframework.unitofwork.DefaultUnitOfWork;
import org.axonframework.unitofwork.UnitOfWork;
import org.axonframework.unitofwork.UnitOfWorkListener;
import org.axonframework.unitofwork.UnitOfWorkListenerAdapter;
import org.axonframework.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GivenWhenThenTestFixture
implements FixtureConfiguration,
TestExecutor {
    private static final Logger logger = LoggerFactory.getLogger(GivenWhenThenTestFixture.class);
    private EventSourcingRepository<?> repository;
    private SimpleCommandBus commandBus;
    private EventBus eventBus;
    private AggregateIdentifier aggregateIdentifier;
    private EventStore eventStore;
    private Collection<DomainEvent> givenEvents;
    private Deque<DomainEvent> storedEvents;
    private List<Event> publishedEvents;
    private long sequenceNumber = 0L;
    private AggregateRoot workingAggregate;
    private boolean reportIllegalStateChange = true;

    GivenWhenThenTestFixture() {
        JmxConfiguration.getInstance().disableMonitoring();
        this.aggregateIdentifier = new UUIDAggregateIdentifier();
        this.eventBus = new RecordingEventBus();
        this.commandBus = new SimpleCommandBus();
        this.eventStore = new RecordingEventStore();
        this.clearGivenWhenState();
    }

    @Override
    public <T extends EventSourcedAggregateRoot> EventSourcingRepository<T> createGenericRepository(Class<T> aggregateClass) {
        this.registerRepository((EventSourcingRepository<?>)new GenericEventSourcingRepository(aggregateClass));
        return this.repository;
    }

    @Override
    public FixtureConfiguration registerRepository(EventSourcingRepository<?> eventSourcingRepository) {
        this.repository = eventSourcingRepository;
        eventSourcingRepository.setEventBus(this.eventBus);
        eventSourcingRepository.setEventStore(this.eventStore);
        return this;
    }

    @Override
    public FixtureConfiguration registerAnnotatedCommandHandler(Object annotatedCommandHandler) {
        AnnotationCommandHandlerAdapter commandHandlerAdapter = new AnnotationCommandHandlerAdapter(annotatedCommandHandler, (CommandBus)this.commandBus);
        commandHandlerAdapter.subscribe();
        return this;
    }

    @Override
    public FixtureConfiguration registerCommandHandler(Class<?> commandType, CommandHandler commandHandler) {
        this.commandBus.subscribe(commandType, commandHandler);
        return this;
    }

    @Override
    public TestExecutor given(DomainEvent ... domainEvents) {
        return this.given(Arrays.asList(domainEvents));
    }

    @Override
    public TestExecutor given(DomainEventStream domainEvents) {
        ArrayList<DomainEvent> eventList = new ArrayList<DomainEvent>();
        while (domainEvents.hasNext()) {
            eventList.add(domainEvents.next());
        }
        return this.given(eventList);
    }

    @Override
    public TestExecutor given(List<DomainEvent> domainEvents) {
        this.clearGivenWhenState();
        for (DomainEvent event : domainEvents) {
            this.setByReflection(DomainEvent.class, "aggregateIdentifier", event, (Serializable)this.aggregateIdentifier);
            this.setByReflection(DomainEvent.class, "sequenceNumber", event, Long.valueOf(this.sequenceNumber++));
        }
        this.givenEvents.addAll(domainEvents);
        return this;
    }

    @Override
    public TestExecutor givenCommands(Object ... commands) {
        return this.givenCommands(Arrays.asList(commands));
    }

    @Override
    public TestExecutor givenCommands(List<?> commands) {
        this.clearGivenWhenState();
        for (Object command : commands) {
            this.commandBus.dispatch(command);
            this.givenEvents.addAll(this.storedEvents);
            this.storedEvents.clear();
        }
        this.publishedEvents.clear();
        return this;
    }

    @Override
    public ResultValidator when(Object command) {
        ResultValidatorImpl resultValidator = new ResultValidatorImpl(this.storedEvents, this.publishedEvents);
        this.commandBus.setInterceptors(Arrays.asList(new AggregateRegisteringInterceptor()));
        this.commandBus.dispatch(command, (CommandCallback)resultValidator);
        this.detectIllegalStateChanges();
        return resultValidator;
    }

    private void detectIllegalStateChanges() {
        if (this.workingAggregate != null && this.reportIllegalStateChange) {
            this.repository.setEventStore(new EventStore(){

                public void appendEvents(String type, DomainEventStream events) {
                }

                public DomainEventStream readEvents(String type, AggregateIdentifier identifier) {
                    ArrayList eventsToStream = new ArrayList(GivenWhenThenTestFixture.this.givenEvents);
                    eventsToStream.addAll(GivenWhenThenTestFixture.this.storedEvents);
                    return new SimpleDomainEventStream(eventsToStream);
                }
            });
            UnitOfWork uow = DefaultUnitOfWork.startAndGet();
            EventSourcedAggregateRoot aggregate2 = (EventSourcedAggregateRoot)this.repository.load(this.aggregateIdentifier);
            uow.rollback();
            this.repository.setEventStore(this.eventStore);
            this.assertValidWorkingAggregateState(aggregate2);
        }
    }

    private void assertValidWorkingAggregateState(EventSourcedAggregateRoot eventSourcedAggregate) {
        for (Field field : ReflectionUtils.fieldsOf(this.workingAggregate.getClass())) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            ReflectionUtils.ensureAccessible((AccessibleObject)field);
            Object workingFieldValue = null;
            Object eventSourcedFieldValue = null;
            try {
                workingFieldValue = field.get(this.workingAggregate);
                eventSourcedFieldValue = field.get(eventSourcedAggregate);
            }
            catch (IllegalAccessException e) {
                logger.warn("Could not access field \"{}\". Unable to detect inappropriate state changes", (Object)field.getName());
            }
            this.ensureValuesEqual(workingFieldValue, eventSourcedFieldValue, field.getName());
        }
    }

    private void ensureValuesEqual(Object workingValue, Object eventSourcedValue, String propertyPath) {
        if (ReflectionUtils.explicitlyUnequal((Object)workingValue, (Object)eventSourcedValue)) {
            throw new AxonAssertionError(String.format("Illegal state change detected! Property \"%s\" has different value when sourcing events\nWorking aggregate value:     <%s>\nValue after applying events: <%s>", propertyPath, workingValue, eventSourcedValue));
        }
        if (workingValue != null && !ReflectionUtils.hasEqualsMethod(workingValue.getClass())) {
            for (Field field : ReflectionUtils.fieldsOf(workingValue.getClass())) {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                ReflectionUtils.ensureAccessible((AccessibleObject)field);
                String newPropertyPath = propertyPath + "." + field.getName();
                Object workingFieldValue = null;
                Object eventSourcedFieldValue = null;
                try {
                    workingFieldValue = field.get(workingValue);
                    eventSourcedFieldValue = field.get(eventSourcedValue);
                }
                catch (IllegalAccessException e) {
                    logger.warn("Could not access field \"{}\". Unable to detect inappropriate state changes.", (Object)newPropertyPath);
                }
                this.ensureValuesEqual(workingFieldValue, eventSourcedFieldValue, newPropertyPath);
            }
        }
    }

    private void clearGivenWhenState() {
        this.storedEvents = new LinkedList<DomainEvent>();
        this.publishedEvents = new ArrayList<Event>();
        this.givenEvents = new ArrayList<DomainEvent>();
        this.sequenceNumber = 0L;
    }

    @Override
    public AggregateIdentifier getAggregateIdentifier() {
        return this.aggregateIdentifier;
    }

    @Override
    public void setAggregateIdentifier(AggregateIdentifier aggregateIdentifier) {
        this.aggregateIdentifier = aggregateIdentifier;
    }

    @Override
    public void setReportIllegalStateChange(boolean reportIllegalStateChange) {
        this.reportIllegalStateChange = reportIllegalStateChange;
    }

    @Override
    public CommandBus getCommandBus() {
        return this.commandBus;
    }

    @Override
    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public EventStore getEventStore() {
        return this.eventStore;
    }

    @Override
    public EventSourcingRepository<?> getRepository() {
        return this.repository;
    }

    private void setByReflection(Class<?> eventClass, String fieldName, DomainEvent event, Serializable value) {
        try {
            Field field = eventClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(event, value);
        }
        catch (Exception e) {
            throw new FixtureExecutionException("This test fixture needs to be able to set fields by reflection", e);
        }
    }

    private class AggregateRegisteringInterceptor
    implements CommandHandlerInterceptor {
        private AggregateRegisteringInterceptor() {
        }

        public Object handle(Object command, UnitOfWork unitOfWork, InterceptorChain interceptorChain) throws Throwable {
            unitOfWork.registerListener((UnitOfWorkListener)new UnitOfWorkListenerAdapter(){

                public void onPrepareCommit(Set<AggregateRoot> aggregateRoots, List<Event> events) {
                    Iterator<AggregateRoot> iterator = aggregateRoots.iterator();
                    if (iterator.hasNext()) {
                        GivenWhenThenTestFixture.this.workingAggregate = iterator.next();
                        if (GivenWhenThenTestFixture.this.workingAggregate.getVersion() == null) {
                            GivenWhenThenTestFixture.this.aggregateIdentifier = GivenWhenThenTestFixture.this.workingAggregate.getIdentifier();
                        }
                    }
                }
            });
            return interceptorChain.proceed();
        }
    }

    private class RecordingEventBus
    implements EventBus {
        private RecordingEventBus() {
        }

        public void publish(Event event) {
            GivenWhenThenTestFixture.this.publishedEvents.add(event);
        }

        public void subscribe(EventListener eventListener) {
        }

        public void unsubscribe(EventListener eventListener) {
        }
    }

    private class RecordingEventStore
    implements EventStore {
        private RecordingEventStore() {
        }

        public void appendEvents(String type, DomainEventStream events) {
            while (events.hasNext()) {
                DomainEvent next = events.next();
                if (!GivenWhenThenTestFixture.this.storedEvents.isEmpty()) {
                    DomainEvent lastEvent = (DomainEvent)GivenWhenThenTestFixture.this.storedEvents.peekLast();
                    if (!lastEvent.getAggregateIdentifier().equals((Object)next.getAggregateIdentifier())) {
                        throw new EventStoreException("Writing events for an unexpected aggregate. This could indicate that a wrong aggregate is being triggered.");
                    }
                    if (lastEvent.getSequenceNumber() != next.getSequenceNumber() - 1L) {
                        throw new EventStoreException(String.format("Unexpected sequence number on stored event. Expected %s, but got %s.", lastEvent.getSequenceNumber() + 1L, next.getSequenceNumber()));
                    }
                }
                GivenWhenThenTestFixture.this.storedEvents.add(next);
            }
        }

        public DomainEventStream readEvents(String type, AggregateIdentifier identifier) {
            if (!GivenWhenThenTestFixture.this.aggregateIdentifier.equals((Object)identifier)) {
                throw new EventStoreException("You probably want to use aggregateIdentifier() on your fixture to get the aggregate identifier to use");
            }
            if (GivenWhenThenTestFixture.this.givenEvents.isEmpty()) {
                throw new AggregateNotFoundException(identifier, "No 'given' events were configured for this aggregate.");
            }
            return new SimpleDomainEventStream(GivenWhenThenTestFixture.this.givenEvents);
        }
    }
}

