/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.saga;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.axonframework.test.AxonAssertionError;
import org.axonframework.test.saga.DescriptionUtils;
import org.axonframework.test.utils.RecordingCommandBus;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

class CommandValidator {
    private final RecordingCommandBus commandBus;

    public CommandValidator(RecordingCommandBus commandBus) {
        this.commandBus = commandBus;
    }

    public void startRecording() {
        this.commandBus.clearCommands();
    }

    public void assertDispatchedEqualTo(Object ... expected) {
        List<Object> actual = this.commandBus.getDispatchedCommands();
        if (actual.size() != expected.length) {
            throw new AxonAssertionError(String.format("Got wrong number of commands dispatched. Expected <%s>, got <%s>", expected.length, actual.size()));
        }
        Iterator<Object> actualIterator = actual.iterator();
        Iterator<Object> expectedIterator = Arrays.asList(expected).iterator();
        int counter = 0;
        while (actualIterator.hasNext()) {
            Object actualItem = actualIterator.next();
            Object expectedItem = expectedIterator.next();
            if (!expectedItem.equals(actualItem)) {
                throw new AxonAssertionError(String.format("Unexpected command at position %s (0-based). Expected <%s>, got <%s>", counter, expectedItem, actualItem));
            }
            ++counter;
        }
    }

    public void assertDispatchedMatching(Matcher<?> matcher) {
        if (!matcher.matches(this.commandBus.getDispatchedCommands())) {
            StringDescription expectedDescription = new StringDescription();
            StringDescription actualDescription = new StringDescription();
            matcher.describeTo((Description)expectedDescription);
            DescriptionUtils.describe(this.commandBus.getDispatchedCommands(), (Description)actualDescription);
            throw new AxonAssertionError(String.format("Incorrect dispatched commands. Expected <%s>, but got <%s>", expectedDescription, actualDescription));
        }
    }
}

