/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.saga;

import java.util.ArrayList;
import java.util.List;
import org.axonframework.domain.Event;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventListener;
import org.axonframework.test.AxonAssertionError;
import org.axonframework.test.matchers.EqualEventMatcher;
import org.axonframework.test.matchers.Matchers;
import org.axonframework.test.saga.DescriptionUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

class EventValidator
implements EventListener {
    private final List<Event> publishedEvents = new ArrayList<Event>();
    private final EventBus eventBus;

    public EventValidator(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void assertPublishedEvents(Matcher<List<? extends Event>> matcher) {
        if (!matcher.matches(this.publishedEvents)) {
            StringDescription expectedDescription = new StringDescription();
            StringDescription actualDescription = new StringDescription();
            matcher.describeTo((Description)expectedDescription);
            DescriptionUtils.describe(this.publishedEvents, (Description)actualDescription);
            throw new AxonAssertionError(String.format("Published events did not match.\nExpected:\n<%s>\n\nGot:\n<%s>\n", expectedDescription, actualDescription));
        }
    }

    public void assertPublishedEvents(Event ... expected) {
        this.assertPublishedEvents((Matcher<List<? extends Event>>)Matchers.exactSequenceOf(this.createEqualToMatchers(expected)));
    }

    public void handle(Event event) {
        this.publishedEvents.add(event);
    }

    public void startRecording() {
        this.eventBus.subscribe((EventListener)this);
    }

    private Matcher<Event>[] createEqualToMatchers(Event[] expected) {
        ArrayList<EqualEventMatcher<Event>> matchers = new ArrayList<EqualEventMatcher<Event>>(expected.length);
        for (Event event : expected) {
            matchers.add(Matchers.equalTo(event));
        }
        return matchers.toArray(new Matcher[matchers.size()]);
    }
}

