/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.axonframework.domain.AggregateIdentifier;
import org.axonframework.domain.DomainEvent;
import org.axonframework.test.FixtureExecutionException;
import org.axonframework.util.ReflectionUtils;

public abstract class DomainEventUtils {
    private static Method identifierSetter;
    private static Method sequenceNumberSetter;
    private static NoSuchMethodException initializationError;

    private DomainEventUtils() {
    }

    public static void setSequenceNumber(DomainEvent event, long sequenceNumber) {
        DomainEventUtils.assertInitialized();
        try {
            ReflectionUtils.ensureAccessible((Method)sequenceNumberSetter);
            sequenceNumberSetter.invoke((Object)event, sequenceNumber);
        }
        catch (IllegalAccessException e) {
            throw new FixtureExecutionException("Cannot inject identifier and sequence number.", e);
        }
        catch (InvocationTargetException e) {
            throw new FixtureExecutionException("Cannot inject identifier and sequence number.", e);
        }
    }

    public static void setAggregateIdentifier(DomainEvent event, AggregateIdentifier identifier) {
        DomainEventUtils.assertInitialized();
        try {
            ReflectionUtils.ensureAccessible((Method)identifierSetter);
            identifierSetter.invoke((Object)event, identifier);
        }
        catch (IllegalAccessException e) {
            throw new FixtureExecutionException("Cannot inject identifier and sequence number.", e);
        }
        catch (InvocationTargetException e) {
            throw new FixtureExecutionException("Cannot inject identifier and sequence number.", e);
        }
    }

    private static void assertInitialized() {
        if (initializationError != null) {
            throw new FixtureExecutionException("Cannot inject identifier and sequence number. An error occurred while initializing this class", initializationError);
        }
    }

    static {
        try {
            identifierSetter = DomainEvent.class.getDeclaredMethod("setAggregateIdentifier", AggregateIdentifier.class);
            sequenceNumberSetter = DomainEvent.class.getDeclaredMethod("setSequenceNumber", Long.TYPE);
        }
        catch (NoSuchMethodException e) {
            initializationError = e;
        }
    }
}

