/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.eventhandling.scheduling.quartz;

import jakarta.annotation.Nonnull;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.scheduling.quartz.EventJobDataBinder;
import org.axonframework.eventhandling.scheduling.quartz.QuartzEventScheduler;
import org.axonframework.serialization.Serializer;
import org.axonframework.spring.messaging.unitofwork.SpringTransactionManager;
import org.quartz.Scheduler;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;

public class QuartzEventSchedulerFactoryBean
implements FactoryBean<QuartzEventScheduler>,
InitializingBean,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private QuartzEventScheduler eventScheduler;
    private Scheduler scheduler;
    private EventBus eventBus;
    private Serializer serializer;
    private String groupIdentifier;
    private EventJobDataBinder eventJobDataBinder;
    private PlatformTransactionManager transactionManager;
    private TransactionDefinition transactionDefinition;

    public QuartzEventScheduler getObject() {
        return this.eventScheduler;
    }

    public Class<?> getObjectType() {
        return QuartzEventScheduler.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() {
        if (this.eventBus == null) {
            this.eventBus = (EventBus)this.applicationContext.getBean(EventBus.class);
        }
        if (this.scheduler == null) {
            this.scheduler = (Scheduler)this.applicationContext.getBean(Scheduler.class);
        }
        if (this.serializer == null) {
            this.serializer = (Serializer)this.applicationContext.getBean("eventSerializer", Serializer.class);
        }
        QuartzEventScheduler.Builder eventSchedulerBuilder = QuartzEventScheduler.builder().scheduler(this.scheduler).eventBus(this.eventBus).serializer(this.serializer);
        if (this.eventJobDataBinder != null) {
            eventSchedulerBuilder.jobDataBinder(this.eventJobDataBinder);
        }
        if (this.transactionManager != null) {
            eventSchedulerBuilder.transactionManager((TransactionManager)new SpringTransactionManager(this.transactionManager, this.transactionDefinition));
        }
        this.eventScheduler = eventSchedulerBuilder.build();
        if (this.groupIdentifier != null) {
            this.eventScheduler.setGroupIdentifier(this.groupIdentifier);
        }
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void setGroupIdentifier(String groupIdentifier) {
        this.groupIdentifier = groupIdentifier;
    }

    public void setEventJobDataBinder(EventJobDataBinder eventJobDataBinder) {
        this.eventJobDataBinder = eventJobDataBinder;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTransactionDefinition(TransactionDefinition transactionDefinition) {
        this.transactionDefinition = transactionDefinition;
    }

    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }
}

