/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import jakarta.annotation.Nonnull;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.axonframework.common.annotation.Internal;
import org.axonframework.configuration.AxonConfiguration;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.LifecycleHandler;
import org.axonframework.configuration.LifecycleRegistry;
import org.axonframework.spring.config.SpringLifecycleShutdownHandler;
import org.axonframework.spring.config.SpringLifecycleStartHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

@Internal
public class SpringLifecycleRegistry
implements BeanFactoryAware,
LifecycleRegistry {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final AtomicInteger uniqueId = new AtomicInteger(0);
    private ConfigurableListableBeanFactory beanFactory;

    public void setBeanFactory(@Nonnull BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public LifecycleRegistry registerLifecyclePhaseTimeout(long timeout, @Nonnull TimeUnit timeUnit) {
        logger.warn("Registering lifecycle phase timeout on a Spring-based LifecycleRegistry is not supported. Please use Spring Boot's \"Graceful Shutdown\" support instead.");
        return this;
    }

    public LifecycleRegistry onStart(int phase, @Nonnull LifecycleHandler startHandler) {
        SpringLifecycleStartHandler springStartHandler = new SpringLifecycleStartHandler(phase, () -> startHandler.run((Configuration)this.beanFactory.getBean(AxonConfiguration.class)));
        this.beanFactory.registerSingleton(this.getBeanName("start"), (Object)springStartHandler);
        return this;
    }

    public LifecycleRegistry onShutdown(int phase, @Nonnull LifecycleHandler shutdownHandler) {
        SpringLifecycleShutdownHandler springShutdownHandler = new SpringLifecycleShutdownHandler(phase, () -> shutdownHandler.run((Configuration)this.beanFactory.getBean(AxonConfiguration.class)));
        this.beanFactory.registerSingleton(this.getBeanName("shutdown") + this.uniqueId.getAndIncrement(), (Object)springShutdownHandler);
        return this;
    }

    private String getBeanName(@Nonnull String type) {
        return "axon-" + type + "-lifecycle-handler-" + this.uniqueId.getAndIncrement();
    }
}

