/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import java.util.Arrays;
import java.util.Optional;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.config.LegacyConfiguration;
import org.axonframework.config.LegacyDefaultConfigurer;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

@Deprecated(forRemoval=true, since="5.0.0")
public class SpringConfigurer
extends LegacyDefaultConfigurer {
    private final ComponentLocator locator;

    public SpringConfigurer(ConfigurableListableBeanFactory beanFactory) {
        this.locator = new ComponentLocator(beanFactory);
    }

    protected <T> Optional<T> defaultComponent(Class<T> type, LegacyConfiguration config) {
        return this.locator.findBean(type);
    }

    private static class ComponentLocator {
        private final ConfigurableListableBeanFactory beanFactory;

        public ComponentLocator(ConfigurableListableBeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        public <T> Optional<T> findBean(Class<T> componentType) {
            Object[] candidates = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, componentType);
            if (candidates.length == 0) {
                return Optional.empty();
            }
            if (candidates.length == 1) {
                return Optional.of(this.beanFactory.getBean(candidates[0], componentType));
            }
            Optional<T> primary = this.findPrimary(componentType, (String[])candidates);
            if (!primary.isPresent()) {
                throw new AxonConfigurationException("Expected single candidate for component [" + componentType.getSimpleName() + "]. Found candidates: " + Arrays.deepToString(candidates));
            }
            return primary;
        }

        private <T> Optional<T> findPrimary(Class<T> componentType, String[] candidates) {
            String primary = null;
            for (String candidate : candidates) {
                if (!this.beanFactory.getMergedBeanDefinition(candidate).isPrimary()) continue;
                if (primary != null) {
                    return Optional.empty();
                }
                primary = candidate;
            }
            if (primary == null) {
                return Optional.empty();
            }
            return Optional.of(this.beanFactory.getBean(primary, componentType));
        }
    }
}

