/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import jakarta.annotation.Nonnull;
import java.util.List;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.config.LegacyConfigurer;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.queryhandling.QueryMessage;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MessageHandlerConfigurer
implements ConfigurerModule,
ApplicationContextAware {
    private final Type type;
    private final List<String> handlerBeans;
    private ApplicationContext applicationContext;

    public MessageHandlerConfigurer(Type type, List<String> beanRefs) {
        this.type = type;
        this.handlerBeans = beanRefs;
    }

    public void configureModule(@Nonnull LegacyConfigurer configurer) {
        switch (this.type.ordinal()) {
            case 1: {
                this.handlerBeans.forEach(handler -> configurer.registerEventHandler(c -> this.applicationContext.getBean(handler)));
                break;
            }
            case 2: {
                this.handlerBeans.forEach(handler -> configurer.registerQueryHandler(c -> this.applicationContext.getBean(handler)));
                break;
            }
            case 0: {
                this.handlerBeans.forEach(handler -> configurer.registerCommandHandler(c -> this.applicationContext.getBean(handler)));
            }
        }
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public static enum Type {
        COMMAND(CommandMessage.class),
        EVENT(EventMessage.class),
        QUERY(QueryMessage.class);

        private final Class<? extends Message<?>> messageType;

        private Type(Class<? extends Message> messageType) {
            this.messageType = messageType;
        }

        public Class<? extends Message<?>> getMessageType() {
            return this.messageType;
        }
    }
}

