/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import jakarta.annotation.Nonnull;
import java.util.Set;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.ConfigurationEnhancer;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringAggregateConfigurer<T>
implements ConfigurationEnhancer,
ApplicationContextAware {
    private final Class<T> aggregateType;
    private final Set<Class<? extends T>> subTypes;
    private String snapshotFilter;
    private String aggregateRepository;
    private String snapshotTriggerDefinition;
    private String cache;
    private String lockFactory;
    private String commandTargetResolver;
    private boolean filterEventsByType;
    private ApplicationContext applicationContext;
    private String aggregateFactory;

    public SpringAggregateConfigurer(Class<T> aggregateType, Set<Class<? extends T>> subTypes) {
        this.aggregateType = aggregateType;
        this.subTypes = subTypes;
    }

    public void setRepository(String aggregateRepository) {
        this.aggregateRepository = aggregateRepository;
    }

    public void setSnapshotFilter(String snapshotFilter) {
        this.snapshotFilter = snapshotFilter;
    }

    public void setSnapshotTriggerDefinition(String snapshotTriggerDefinition) {
        this.snapshotTriggerDefinition = snapshotTriggerDefinition;
    }

    public void setCommandTargetResolver(String commandTargetResolver) {
        this.commandTargetResolver = commandTargetResolver;
    }

    public void setFilterEventsByType(boolean filterEventsByType) {
        this.filterEventsByType = filterEventsByType;
    }

    public void setCache(String cache) {
        this.cache = cache;
    }

    public void setLockFactory(String lockFactory) {
        this.lockFactory = lockFactory;
    }

    public void setAggregateFactory(String aggregateFactory) {
        this.aggregateFactory = aggregateFactory;
    }

    public void enhance(@Nonnull ComponentRegistry registry) {
        if (this.snapshotFilter != null) {
            // empty if block
        }
        if (this.aggregateRepository != null || this.isEntityManagerAnnotationPresent(this.aggregateType)) {
            // empty if block
        }
        if (this.snapshotTriggerDefinition != null) {
            // empty if block
        }
        if (this.commandTargetResolver != null) {
            // empty if block
        }
        if (this.cache != null) {
            // empty if block
        }
        if (this.lockFactory != null) {
            // empty if block
        }
        if (this.aggregateFactory != null) {
            // empty if block
        }
    }

    private boolean isEntityManagerAnnotationPresent(Class<T> type) {
        return AnnotationUtils.isAnnotationPresent(type, (String)"javax.persistence.Entity") || AnnotationUtils.isAnnotationPresent(type, (String)"jakarta.persistence.Entity");
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

