/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.eventhandling.scheduling.java;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;
import org.axonframework.common.AxonThreadFactory;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.scheduling.java.SimpleEventScheduler;
import org.axonframework.spring.messaging.unitofwork.SpringTransactionManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class SimpleEventSchedulerFactoryBean
implements FactoryBean<SimpleEventScheduler>,
InitializingBean,
DisposableBean,
ApplicationContextAware {
    private EventBus eventBus;
    private ScheduledExecutorService executorService;
    private ScheduledExecutorService executorServiceToShutDown;
    private SimpleEventScheduler eventScheduler;
    private ApplicationContext applicationContext;
    private PlatformTransactionManager transactionManager;
    private TransactionDefinition transactionDefinition = new DefaultTransactionDefinition();

    public SimpleEventScheduler getObject() {
        return this.eventScheduler;
    }

    public Class<?> getObjectType() {
        return SimpleEventScheduler.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() {
        if (this.executorService == null) {
            this.executorServiceToShutDown = this.executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new AxonThreadFactory(SimpleEventSchedulerFactoryBean.class.getSimpleName()));
        }
        if (this.eventBus == null) {
            this.eventBus = (EventBus)this.applicationContext.getBean(EventBus.class);
        }
        SimpleEventScheduler.Builder eventSchedulerBuilder = SimpleEventScheduler.builder().scheduledExecutorService(this.executorService).eventBus(this.eventBus);
        if (this.transactionManager != null) {
            eventSchedulerBuilder.transactionManager((TransactionManager)new SpringTransactionManager(this.transactionManager, this.transactionDefinition));
        }
        this.eventScheduler = eventSchedulerBuilder.build();
    }

    public void destroy() {
        if (this.executorServiceToShutDown != null) {
            this.executorServiceToShutDown.shutdown();
        }
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void setExecutorService(ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTransactionDefinition(TransactionDefinition transactionDefinition) {
        this.transactionDefinition = transactionDefinition;
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

