/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import javax.annotation.Nonnull;
import org.axonframework.config.Configurer;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.modelling.saga.repository.SagaStore;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringSagaConfigurer
implements ConfigurerModule,
ApplicationContextAware {
    private final Class<?> sagaType;
    private String sagaStore;
    private ApplicationContext applicationContext;

    public SpringSagaConfigurer(Class<?> sagaType) {
        this.sagaType = sagaType;
    }

    public void setSagaStore(String sagaStore) {
        this.sagaStore = sagaStore;
    }

    public void configureModule(Configurer configurer) {
        configurer.eventProcessing().registerSaga(this.sagaType, sagaConfigurer -> {
            if (this.sagaStore != null && !"".equals(this.sagaStore)) {
                sagaConfigurer.configureSagaStore(c -> (SagaStore)this.applicationContext.getBean(this.sagaStore, SagaStore.class));
            }
        });
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

