/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.StringUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.modelling.command.Repository;
import org.axonframework.spring.config.SpringAggregateConfigurer;
import org.axonframework.spring.eventsourcing.SpringPrototypeAggregateFactory;
import org.axonframework.spring.modelling.SpringRepositoryFactoryBean;
import org.axonframework.spring.stereotype.Aggregate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;

public class SpringAggregateLookup
implements BeanDefinitionRegistryPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(SpringAggregateLookup.class);
    private static final String REPOSITORY = "repository";
    private static final String REPOSITORY_BEAN = "Repository";
    private static final String SNAPSHOT_FILTER = "snapshotFilter";
    private static final String SNAPSHOT_TRIGGER_DEFINITION = "snapshotTriggerDefinition";
    private static final String COMMAND_TARGET_RESOLVER = "commandTargetResolver";
    private static final String CACHE = "cache";
    private static final String LOCK_FACTORY = "lockFactory";

    public static <A> Map<SpringAggregate<? super A>, Map<Class<? extends A>, String>> buildAggregateHierarchy(ListableBeanFactory beanFactory, String[] aggregatePrototypes) {
        HashMap<SpringAggregate<A>, Map<Class<A>, String>> hierarchy = new HashMap<SpringAggregate<A>, Map<Class<A>, String>>();
        for (String prototype : aggregatePrototypes) {
            Class aggregateType = beanFactory.getType(prototype);
            if (aggregateType == null) {
                logger.info("Cannot find Aggregate class for type [{}], hence ignoring.", (Object)prototype);
                break;
            }
            SpringAggregate springAggregate = new SpringAggregate(prototype, aggregateType);
            Class<A> topType = SpringAggregateLookup.topAnnotatedAggregateType(aggregateType);
            SpringAggregate topSpringAggregate = new SpringAggregate(SpringAggregateLookup.beanName(beanFactory, topType), topType);
            hierarchy.compute(topSpringAggregate, (type, subtypes) -> {
                if (subtypes == null) {
                    subtypes = new HashMap<Class, String>();
                }
                if (!type.equals(springAggregate)) {
                    subtypes.put(aggregateType, prototype);
                }
                return subtypes;
            });
        }
        return hierarchy;
    }

    private static <A> String beanName(ListableBeanFactory beanFactory, Class<A> type) {
        String[] beanNamesForType = beanFactory.getBeanNamesForType(type);
        if (beanNamesForType.length == 0) {
            throw new AxonConfigurationException(String.format("There are no spring beans for '%s' defined.", type.getName()));
        }
        if (beanNamesForType.length != 1) {
            logger.debug("There are {} beans defined for '{}', making this a polymorphic aggregate.", (Object)beanNamesForType.length, (Object)type.getName());
        }
        return beanNamesForType[0];
    }

    private static <A> Class<? super A> topAnnotatedAggregateType(Class<A> type) {
        Class<A> top;
        Class<A> topAnnotated = top = type;
        while (!Object.class.equals(top) && !Object.class.equals(top.getSuperclass())) {
            if (!(top = top.getSuperclass()).isAnnotationPresent(Aggregate.class)) continue;
            topAnnotated = top;
        }
        return topAnnotated;
    }

    public void postProcessBeanFactory(@Nonnull ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof BeanDefinitionRegistry)) {
            logger.warn("Given bean factory is not a BeanDefinitionRegistry. Cannot auto-configure Aggregates");
            return;
        }
        BeanDefinitionRegistry bdRegistry = (BeanDefinitionRegistry)beanFactory;
        String[] aggregateBeans = beanFactory.getBeanNamesForAnnotation(Aggregate.class);
        Map hierarchy = SpringAggregateLookup.buildAggregateHierarchy((ListableBeanFactory)beanFactory, aggregateBeans);
        for (Map.Entry aggregate : hierarchy.entrySet()) {
            Class aggregateType = aggregate.getKey().getClassType();
            String aggregatePrototype = aggregate.getKey().getBeanName();
            String registrarBeanName = aggregatePrototype + "$$Registrar";
            if (beanFactory.containsBeanDefinition(registrarBeanName)) {
                logger.info("Registrar for {} already available. Skipping configuration", (Object)aggregatePrototype);
                break;
            }
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(aggregatePrototype);
            if (!beanDefinition.isPrototype() || aggregateType == null) continue;
            AnnotationUtils.findAnnotationAttributes(aggregateType, Aggregate.class).map(props -> this.buildAggregateBeanDefinition(beanFactory, aggregateType, aggregatePrototype, (Map)aggregate.getValue(), (Map<String, Object>)props)).ifPresent(registrarBeanDefinition -> bdRegistry.registerBeanDefinition(registrarBeanName, registrarBeanDefinition));
        }
    }

    private BeanDefinition buildAggregateBeanDefinition(ConfigurableListableBeanFactory registry, Class<?> aggregateType, String aggregateBeanName, Map<Class<?>, String> subTypes, Map<String, Object> props) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(SpringAggregateConfigurer.class).setRole(0).addConstructorArgValue(aggregateType).addConstructorArgValue(subTypes.keySet());
        if (StringUtils.nonEmptyOrNull((String)((String)props.get(SNAPSHOT_FILTER)))) {
            beanDefinitionBuilder.addPropertyValue(SNAPSHOT_FILTER, props.get(SNAPSHOT_FILTER));
        }
        if (StringUtils.nonEmptyOrNull((String)((String)props.get(SNAPSHOT_TRIGGER_DEFINITION)))) {
            beanDefinitionBuilder.addPropertyValue(SNAPSHOT_TRIGGER_DEFINITION, props.get(SNAPSHOT_TRIGGER_DEFINITION));
        }
        if (StringUtils.nonEmptyOrNull((String)((String)props.get(COMMAND_TARGET_RESOLVER)))) {
            beanDefinitionBuilder.addPropertyValue(COMMAND_TARGET_RESOLVER, props.get(COMMAND_TARGET_RESOLVER));
        }
        if (StringUtils.nonEmptyOrNull((String)((String)props.get(CACHE)))) {
            beanDefinitionBuilder.addPropertyValue(CACHE, props.get(CACHE));
        }
        if (StringUtils.nonEmptyOrNull((String)((String)props.get(LOCK_FACTORY)))) {
            beanDefinitionBuilder.addPropertyValue(LOCK_FACTORY, props.get(LOCK_FACTORY));
        }
        if (StringUtils.nonEmptyOrNull((String)((String)props.get(REPOSITORY)))) {
            beanDefinitionBuilder.addPropertyValue(REPOSITORY, props.get(REPOSITORY));
        } else {
            String repositoryName = StringUtils.lowerCaseFirstCharacterOf((String)aggregateType.getSimpleName()) + REPOSITORY_BEAN;
            if (registry.containsBean(repositoryName)) {
                Class type = registry.getType(repositoryName);
                if (type == null || Repository.class.isAssignableFrom(type)) {
                    beanDefinitionBuilder.addPropertyValue(REPOSITORY, (Object)repositoryName);
                }
            } else {
                ((BeanDefinitionRegistry)registry).registerBeanDefinition(repositoryName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(SpringRepositoryFactoryBean.class).addConstructorArgValue(aggregateType).addAutowiredProperty("configuration").getBeanDefinition());
            }
        }
        String aggregateFactory = StringUtils.lowerCaseFirstCharacterOf((String)aggregateType.getSimpleName()) + "AggregateFactory";
        if (!registry.containsBeanDefinition(aggregateFactory)) {
            ((BeanDefinitionRegistry)registry).registerBeanDefinition(aggregateFactory, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(SpringPrototypeAggregateFactory.class).addConstructorArgValue((Object)aggregateBeanName).addConstructorArgValue(subTypes).getBeanDefinition());
        }
        beanDefinitionBuilder.addPropertyValue("aggregateFactory", (Object)aggregateFactory);
        return beanDefinitionBuilder.getBeanDefinition();
    }

    public void postProcessBeanDefinitionRegistry(@Nonnull BeanDefinitionRegistry registry) throws BeansException {
    }

    static class SpringAggregate<T> {
        private final String beanName;
        private final Class<T> classType;

        private SpringAggregate(String beanName, Class<T> classType) {
            this.beanName = beanName;
            this.classType = classType;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public Class<T> getClassType() {
            return this.classType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpringAggregate that = (SpringAggregate)o;
            return Objects.equals(this.beanName, that.beanName) && Objects.equals(this.classType, that.classType);
        }

        public int hashCode() {
            return Objects.hash(this.beanName, this.classType);
        }
    }
}

