/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.axonframework.config.Configuration;
import org.axonframework.config.Configurer;
import org.axonframework.spring.event.AxonStartedEvent;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.lang.NonNull;

public class SpringAxonConfiguration
implements FactoryBean<Configuration>,
SmartLifecycle {
    public static final int LIFECYCLE_PHASE = 0x7FFFF3FF;
    private final Configurer configurer;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final AtomicReference<Configuration> configuration = new AtomicReference();
    private ApplicationContext applicationContext;

    public SpringAxonConfiguration(Configurer configurer) {
        this.configurer = configurer;
    }

    @NonNull
    public Configuration getObject() {
        Configuration c = this.configuration.get();
        if (c != null) {
            return c;
        }
        this.configuration.compareAndSet(null, this.configurer.buildConfiguration());
        return this.configuration.get();
    }

    public Class<?> getObjectType() {
        return Configuration.class;
    }

    public void start() {
        if (this.isRunning.compareAndSet(false, true)) {
            this.getObject().start();
            this.applicationContext.publishEvent((Object)new AxonStartedEvent());
        }
    }

    public void stop() {
        Configuration c = this.configuration.get();
        if (this.isRunning.compareAndSet(true, false) && c != null) {
            c.shutdown();
        }
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public int getPhase() {
        return 0x7FFFF3FF;
    }
}

