/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.authorization;

import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class MessageAuthorizationDispatchInterceptor<T extends Message<?>>
implements MessageDispatchInterceptor<T> {
    private static final Logger logger = LoggerFactory.getLogger(MessageAuthorizationDispatchInterceptor.class);

    @Nonnull
    public T handle(@Nonnull T message) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            logger.debug("No authentication found.");
            return message;
        }
        logger.debug("Adding message metadata for username & authorities.");
        HashMap<String, Object> authenticationDetails = new HashMap<String, Object>();
        authenticationDetails.put("username", authentication.getPrincipal());
        authenticationDetails.put("authorities", authentication.getAuthorities());
        return (T)message.andMetaData(authenticationDetails);
    }

    @Nonnull
    public BiFunction<Integer, T, T> handle(@Nonnull List<? extends T> list) {
        return (position, message) -> this.handle(message);
    }
}

