/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import java.util.List;
import org.axonframework.config.Configuration;
import org.axonframework.config.EventProcessingConfigurer;
import org.axonframework.config.ModuleConfiguration;
import org.axonframework.spring.config.AxonConfiguration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class EventHandlerRegistrar
implements InitializingBean,
SmartLifecycle {
    private static final int EARLY_PHASE = -2147482648;
    private final AxonConfiguration axonConfiguration;
    private final EventProcessingConfigurer eventProcessingConfigurer;
    private final ModuleConfiguration eventProcessingConfiguration;
    private volatile boolean running = false;
    private volatile boolean initialized;

    public EventHandlerRegistrar(AxonConfiguration axonConfiguration, ModuleConfiguration eventProcessingConfiguration, EventProcessingConfigurer eventProcessingConfigurer) {
        this.axonConfiguration = axonConfiguration;
        this.eventProcessingConfiguration = eventProcessingConfiguration;
        this.eventProcessingConfigurer = eventProcessingConfigurer;
    }

    public void setEventHandlers(List<Object> beans) {
        AnnotationAwareOrderComparator.sort(beans);
        beans.forEach(b -> this.eventProcessingConfigurer.registerEventHandler(c -> b));
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void start() {
        this.eventProcessingConfiguration.start();
        this.running = true;
    }

    public void stop() {
        this.eventProcessingConfiguration.shutdown();
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return -2147482648;
    }

    public void afterPropertiesSet() {
        if (!this.initialized) {
            this.initialized = true;
            this.eventProcessingConfiguration.initialize((Configuration)this.axonConfiguration);
        }
    }
}

