/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.springframework.aop.IntroductionInfo;
import org.springframework.aop.IntroductionInterceptor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ClassUtils;

public abstract class AbstractAnnotationHandlerBeanPostProcessor<I, T extends I>
implements BeanPostProcessor,
BeanFactoryAware {
    private ParameterResolverFactory parameterResolverFactory;
    private HandlerDefinition handlerDefinition;
    private BeanFactory beanFactory;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (beanName != null && this.beanFactory.containsBean(beanName) && !this.beanFactory.isSingleton(beanName)) {
            return bean;
        }
        Class<?> targetClass = bean.getClass();
        ClassLoader classLoader = targetClass.getClassLoader();
        if (this.parameterResolverFactory == null) {
            this.parameterResolverFactory = ClasspathParameterResolverFactory.forClassLoader((ClassLoader)classLoader);
        }
        if (this.handlerDefinition == null) {
            this.handlerDefinition = ClasspathHandlerDefinition.forClassLoader((ClassLoader)classLoader);
        }
        if (this.isPostProcessingCandidate(targetClass)) {
            T adapter = this.initializeAdapterFor(bean, this.parameterResolverFactory, this.handlerDefinition);
            return this.createAdapterProxy(bean, adapter, this.getAdapterInterfaces(), true, classLoader);
        }
        if (!this.isInstance(bean, this.getAdapterInterfaces()) && this.isPostProcessingCandidate(AopProxyUtils.ultimateTargetClass((Object)bean))) {
            try {
                Object targetBean = ((Advised)bean).getTargetSource().getTarget();
                Object proxyInvokingBean = this.createJavaProxyInvoker(bean, targetBean);
                T adapter = this.initializeAdapterFor(proxyInvokingBean, this.parameterResolverFactory, this.handlerDefinition);
                return this.createAdapterProxy(proxyInvokingBean, adapter, this.getAdapterInterfaces(), false, classLoader);
            }
            catch (Exception e) {
                throw new AxonConfigurationException("Unable to wrap annotated handler.", (Throwable)e);
            }
        }
        return bean;
    }

    private boolean isInstance(Object bean, Class<?>[] adapterInterfaces) {
        for (Class<?> adapterInterface : adapterInterfaces) {
            if (!adapterInterface.isInstance(bean)) continue;
            return true;
        }
        return false;
    }

    private Object createJavaProxyInvoker(Object javaProxy, Object target) {
        ProxyFactory pf = new ProxyFactory(target);
        pf.addAdvice((Advice)new ProxyOrImplementationInvocationInterceptor(javaProxy, target));
        pf.setProxyTargetClass(true);
        pf.setExposeProxy(true);
        return pf.getProxy(target.getClass().getClassLoader());
    }

    protected abstract Class<?>[] getAdapterInterfaces();

    protected abstract boolean isPostProcessingCandidate(Class<?> var1);

    protected abstract T initializeAdapterFor(Object var1, ParameterResolverFactory var2, HandlerDefinition var3);

    private I createAdapterProxy(Object annotatedHandler, T adapter, Class<?>[] adapterInterface, boolean proxyTargetClass, ClassLoader classLoader) {
        ProxyFactory pf = new ProxyFactory(annotatedHandler);
        for (Class<?> iClass : adapterInterface) {
            pf.addAdvice((Advice)new AdapterIntroductionInterceptor(adapter, iClass));
            pf.addInterface(iClass);
        }
        pf.setProxyTargetClass(proxyTargetClass);
        pf.setExposeProxy(true);
        return (I)pf.getProxy(classLoader);
    }

    public void setParameterResolverFactory(ParameterResolverFactory parameterResolverFactory) {
        this.parameterResolverFactory = parameterResolverFactory;
    }

    public void setHandlerDefinition(HandlerDefinition handlerDefinition) {
        this.handlerDefinition = handlerDefinition;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    private static final class AdapterIntroductionInterceptor
    implements IntroductionInfo,
    IntroductionInterceptor {
        private final Object adapter;
        private final Class<?> adapterInterface;

        private AdapterIntroductionInterceptor(Object adapter, Class<?> adapterInterface) {
            this.adapter = adapter;
            this.adapterInterface = adapterInterface;
        }

        public boolean implementsInterface(Class<?> intf) {
            return intf.equals(this.adapterInterface);
        }

        public Object invoke(MethodInvocation invocation) throws Exception {
            Class<?> declaringClass = invocation.getMethod().getDeclaringClass();
            try {
                if (declaringClass.isAssignableFrom(this.adapterInterface)) {
                    return invocation.getMethod().invoke(this.adapter, invocation.getArguments());
                }
                return invocation.proceed();
            }
            catch (InvocationTargetException e) {
                throw e.getCause() instanceof Exception ? (Exception)e.getCause() : e;
            }
            catch (Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new InvocationTargetException(e);
            }
        }

        public Class[] getInterfaces() {
            return new Class[]{this.adapterInterface};
        }
    }

    private static final class ProxyOrImplementationInvocationInterceptor
    implements IntroductionInfo,
    IntroductionInterceptor {
        private final Object proxy;
        private final Method[] proxyMethods;
        private final Class[] interfaces;

        private ProxyOrImplementationInvocationInterceptor(Object proxy, Object implementation) {
            this.proxy = proxy;
            this.proxyMethods = proxy.getClass().getDeclaredMethods();
            this.interfaces = ClassUtils.getAllInterfaces((Object)implementation);
        }

        public boolean implementsInterface(Class<?> intf) {
            for (Class iFace : this.interfaces) {
                if (!intf.equals(iFace)) continue;
                return true;
            }
            return false;
        }

        public Class[] getInterfaces() {
            return this.interfaces;
        }

        public Object invoke(MethodInvocation invocation) throws Exception {
            try {
                for (Method proxyMethod : this.proxyMethods) {
                    if (!proxyMethod.getName().equals(invocation.getMethod().getName()) || !Arrays.equals(proxyMethod.getParameterTypes(), invocation.getMethod().getParameterTypes())) continue;
                    return proxyMethod.invoke(this.proxy, invocation.getArguments());
                }
                return invocation.proceed();
            }
            catch (InvocationTargetException e) {
                throw e.getCause() instanceof Exception ? (Exception)e.getCause() : e;
            }
            catch (Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new InvocationTargetException(e);
            }
        }
    }
}

