/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.messaging;

import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.axonframework.common.Registration;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.SubscribableMessageSource;
import org.springframework.messaging.MessageHandler;

public class InboundEventMessageChannelAdapter
implements MessageHandler,
SubscribableMessageSource<EventMessage<?>> {
    private final CopyOnWriteArrayList<Consumer<List<? extends EventMessage<?>>>> messageProcessors = new CopyOnWriteArrayList();

    public InboundEventMessageChannelAdapter() {
    }

    public InboundEventMessageChannelAdapter(EventBus eventBus) {
        this.messageProcessors.add(arg_0 -> ((EventBus)eventBus).publish(arg_0));
    }

    public Registration subscribe(Consumer<List<? extends EventMessage<?>>> messageProcessor) {
        this.messageProcessors.add(messageProcessor);
        return () -> this.messageProcessors.remove(messageProcessor);
    }

    public void handleMessage(org.springframework.messaging.Message<?> message) {
        List<GenericEventMessage<?>> messages = Collections.singletonList(this.transformMessage(message));
        for (Consumer<List<EventMessage<?>>> messageProcessor : this.messageProcessors) {
            messageProcessor.accept(messages);
        }
    }

    protected GenericEventMessage<?> transformMessage(org.springframework.messaging.Message<?> message) {
        return new GenericEventMessage((Message)new GenericMessage(message.getPayload(), (Map)message.getHeaders()), () -> Instant.ofEpochMilli(message.getHeaders().getTimestamp()));
    }
}

