/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.messaging.unitofwork;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.common.Assert;
import org.axonframework.common.transaction.Transaction;
import org.axonframework.common.transaction.TransactionIsolationLevel;
import org.axonframework.common.transaction.TransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class SpringTransactionManager
implements TransactionManager {
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition defaultTransactionDefinition;
    private final Map<Integer, TransactionDefinition> transactionDefinitions = new ConcurrentHashMap<Integer, TransactionDefinition>();

    public SpringTransactionManager(PlatformTransactionManager transactionManager, TransactionDefinition transactionDefinition) {
        Assert.notNull((Object)transactionManager, (String)"transactionManager may not be null");
        this.transactionManager = transactionManager;
        this.defaultTransactionDefinition = transactionDefinition;
    }

    public SpringTransactionManager(PlatformTransactionManager transactionManager) {
        this(transactionManager, (TransactionDefinition)new DefaultTransactionDefinition());
    }

    public Transaction startTransaction(TransactionIsolationLevel isolationLevel) {
        final TransactionStatus status = this.transactionManager.getTransaction(this.transactionDefinitions.computeIfAbsent(isolationLevel.get(), i -> {
            DefaultTransactionDefinition result = new DefaultTransactionDefinition(this.defaultTransactionDefinition);
            result.setIsolationLevel(i.intValue());
            return result;
        }));
        return new Transaction(){

            public void commit() {
                SpringTransactionManager.this.commitTransaction(status);
            }

            public void rollback() {
                SpringTransactionManager.this.rollbackTransaction(status);
            }
        };
    }

    protected void commitTransaction(TransactionStatus status) {
        if (status.isNewTransaction() && !status.isCompleted()) {
            this.transactionManager.commit(status);
        }
    }

    protected void rollbackTransaction(TransactionStatus status) {
        if (status.isNewTransaction() && !status.isCompleted()) {
            this.transactionManager.rollback(status);
        }
    }
}

