/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import java.util.List;
import org.axonframework.config.Configuration;
import org.axonframework.config.EventHandlingConfiguration;
import org.axonframework.spring.config.AxonConfiguration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.SmartLifecycle;

public class DefaultSpringEventHandlingConfiguration
implements InitializingBean,
SmartLifecycle {
    private final EventHandlingConfiguration delegate = EventHandlingConfiguration.assigningHandlersByPackage();
    private Configuration config;
    private volatile boolean running = false;

    public void setEventHandlers(List<Object> beans) {
        beans.forEach(b -> this.delegate.registerEventHandler(c -> b));
    }

    public void setAxonConfiguration(AxonConfiguration axonConfiguration) {
        this.config = axonConfiguration;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void start() {
        this.delegate.start();
        this.running = true;
    }

    public void stop() {
        this.delegate.shutdown();
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return Integer.MIN_VALUE;
    }

    public void afterPropertiesSet() throws Exception {
        this.delegate.initialize(this.config);
    }
}

