/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.messaging.eventbus;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.axonframework.common.Registration;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.spring.messaging.eventbus.MessageHandlerAdapter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.support.GenericMessage;

public class SpringMessagingTerminal {
    private final ConcurrentMap<Consumer<List<? extends EventMessage<?>>>, MessageHandler> handlers = new ConcurrentHashMap();
    private final EventBus eventBus;
    private Registration eventBusRegistration;
    private SubscribableChannel channel;

    public SpringMessagingTerminal(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void start() {
        this.eventBusRegistration = this.eventBus.subscribe(this::send);
    }

    public void shutDown() {
        Optional.ofNullable(this.eventBusRegistration).ifPresent(Registration::cancel);
    }

    protected void send(List<? extends EventMessage<?>> events) {
        for (EventMessage<?> event : events) {
            this.channel.send((Message)new GenericMessage(event.getPayload(), (Map)event.getMetaData()));
        }
    }

    public Registration subscribe(Consumer<List<? extends EventMessage<?>>> eventProcessor) {
        MessageHandlerAdapter messagehandler = new MessageHandlerAdapter(eventProcessor);
        MessageHandler oldHandler = this.handlers.putIfAbsent(eventProcessor, messagehandler);
        if (oldHandler == null) {
            this.channel.subscribe((MessageHandler)messagehandler);
        }
        return () -> {
            MessageHandler messageHandler = (MessageHandler)this.handlers.remove(eventProcessor);
            if (messageHandler != null) {
                this.channel.unsubscribe(messageHandler);
                return true;
            }
            return false;
        };
    }

    public void setChannel(SubscribableChannel channel) {
        this.channel = channel;
    }
}

