/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config.annotation;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import org.axonframework.commandhandling.AnnotationCommandHandlerAdapter;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.SupportedCommandNamesAware;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.spring.config.AbstractAnnotationHandlerBeanPostProcessor;
import org.springframework.util.ReflectionUtils;

public class AnnotationCommandHandlerBeanPostProcessor
extends AbstractAnnotationHandlerBeanPostProcessor<MessageHandler<CommandMessage<?>>, AnnotationCommandHandlerAdapter> {
    @Override
    protected Class<?>[] getAdapterInterfaces() {
        return new Class[]{MessageHandler.class, SupportedCommandNamesAware.class};
    }

    @Override
    protected boolean isPostProcessingCandidate(Class<?> targetClass) {
        return this.hasCommandHandlerMethod(targetClass);
    }

    @Override
    protected AnnotationCommandHandlerAdapter initializeAdapterFor(Object bean, ParameterResolverFactory parameterResolverFactory) {
        return new AnnotationCommandHandlerAdapter(bean, parameterResolverFactory);
    }

    private boolean hasCommandHandlerMethod(Class<?> beanClass) {
        AtomicBoolean result = new AtomicBoolean(false);
        ReflectionUtils.doWithMethods(beanClass, (ReflectionUtils.MethodCallback)new HasEventHandlerAnnotationMethodCallback(result));
        return result.get();
    }

    private static final class HasEventHandlerAnnotationMethodCallback
    implements ReflectionUtils.MethodCallback {
        private final AtomicBoolean result;

        private HasEventHandlerAnnotationMethodCallback(AtomicBoolean result) {
            this.result = result;
        }

        public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
            if (method.isAnnotationPresent(CommandHandler.class)) {
                this.result.set(true);
            }
        }
    }
}

