/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config.eventhandling;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.axonframework.eventhandling.EventListener;
import org.axonframework.spring.config.eventhandling.DefaultEventProcessorSelector;
import org.axonframework.spring.config.eventhandling.EventProcessorSelector;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

public class AutowiringEventProcessorSelector
implements EventProcessorSelector,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private final List<EventProcessorSelector> selectors = new ArrayList<EventProcessorSelector>();
    private volatile boolean initialized;

    @Override
    public String selectEventProcessor(EventListener eventListener) {
        if (!this.initialized) {
            this.initialize();
        }
        String eventProcessor = null;
        Iterator<EventProcessorSelector> selectorIterator = this.selectors.iterator();
        while (eventProcessor == null && selectorIterator.hasNext()) {
            eventProcessor = selectorIterator.next().selectEventProcessor(eventListener);
        }
        return eventProcessor;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        Map candidates = this.applicationContext.getBeansOfType(EventProcessorSelector.class);
        TreeSet<OrderedEventProcessorSelector> orderedCandidates = new TreeSet<OrderedEventProcessorSelector>();
        for (Map.Entry entry : candidates.entrySet()) {
            if (entry.getValue() == this) continue;
            orderedCandidates.add(new OrderedEventProcessorSelector((String)entry.getKey(), (EventProcessorSelector)entry.getValue()));
        }
        for (OrderedEventProcessorSelector candidate : orderedCandidates) {
            this.selectors.add(candidate.selector);
        }
        if (this.selectors.isEmpty()) {
            this.selectors.add(new DefaultEventProcessorSelector());
        }
    }

    private static final class OrderedEventProcessorSelector
    implements Comparable<OrderedEventProcessorSelector> {
        private final String name;
        private final EventProcessorSelector selector;
        private final int order;

        private OrderedEventProcessorSelector(String name, EventProcessorSelector selector) {
            this.name = name;
            this.selector = selector;
            this.order = selector instanceof Ordered ? ((Ordered)selector).getOrder() : (selector.getClass().isAnnotationPresent(Order.class) ? selector.getClass().getAnnotation(Order.class).value() : 0);
        }

        @Override
        public int compareTo(OrderedEventProcessorSelector o) {
            if (this.order == o.order) {
                return this.name.compareTo(o.name);
            }
            return this.order < o.order ? -1 : 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OrderedEventProcessorSelector that = (OrderedEventProcessorSelector)o;
            return this.order == that.order && this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.order;
            return result;
        }
    }
}

