/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config.eventhandling;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.axonframework.eventhandling.EventListener;
import org.axonframework.spring.config.eventhandling.AbstractEventProcessorSelector;

public class ClassNamePrefixEventProcessorSelector
extends AbstractEventProcessorSelector {
    private final Map<String, String> eventProcessorToPrefix;
    private final String defaultEventProcessor;

    public ClassNamePrefixEventProcessorSelector(String prefix, String eventProcessor) {
        this(Collections.singletonMap(prefix, eventProcessor));
    }

    public ClassNamePrefixEventProcessorSelector(Map<String, String> eventProcessorToPrefix) {
        this(eventProcessorToPrefix, null);
    }

    public ClassNamePrefixEventProcessorSelector(Map<String, String> eventProcessorToPrefix, String defaultEventProcessor) {
        this.defaultEventProcessor = defaultEventProcessor;
        this.eventProcessorToPrefix = new TreeMap<String, String>(new ReverseStringComparator());
        this.eventProcessorToPrefix.putAll(eventProcessorToPrefix);
    }

    @Override
    public String doSelectEventHandlerManager(EventListener eventListener, Class<?> listenerType) {
        String listenerName = listenerType.getName();
        for (Map.Entry<String, String> entry : this.eventProcessorToPrefix.entrySet()) {
            if (!listenerName.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return this.defaultEventProcessor;
    }

    private static class ReverseStringComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = -1653838988719816515L;

        private ReverseStringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o2.compareTo(o1);
        }
    }
}

