/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.autoconfig;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.axonframework.springboot.ConverterProperties;
import org.axonframework.springboot.autoconfig.AxonAutoConfiguration;
import org.axonframework.springboot.autoconfig.CBORMapperAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;

@AutoConfiguration
@AutoConfigureBefore(value={AxonAutoConfiguration.class, CBORMapperAutoConfiguration.class})
@AutoConfigureAfter(name={"org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration"})
@ConditionalOnClass(name={"com.fasterxml.jackson.databind.ObjectMapper"})
@EnableConfigurationProperties(value={ConverterProperties.class})
public class ObjectMapperAutoConfiguration {
    @Bean(value={"defaultAxonObjectMapper"})
    @ConditionalOnMissingBean
    @Conditional(value={JacksonConfiguredCondition.class})
    public ObjectMapper defaultAxonObjectMapper() {
        return new ObjectMapper().findAndRegisterModules();
    }

    private static class JacksonConfiguredCondition
    extends AnyNestedCondition {
        public JacksonConfiguredCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(name={"axon.converter.events"}, havingValue="jackson")
        static class EventsJacksonCondition {
            EventsJacksonCondition() {
            }
        }

        @ConditionalOnProperty(name={"axon.converter.messages"}, havingValue="jackson")
        static class MessagesJacksonCondition {
            MessagesJacksonCondition() {
            }
        }

        @ConditionalOnProperty(name={"axon.converter.general"}, havingValue="jackson", matchIfMissing=true)
        static class GeneralJacksonCondition {
            GeneralJacksonCondition() {
            }
        }

        @ConditionalOnProperty(name={"axon.converter.general"}, havingValue="default", matchIfMissing=true)
        static class GeneralDefaultCondition {
            GeneralDefaultCondition() {
            }
        }
    }
}

