/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.autoconfig;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import org.axonframework.axonserver.connector.TagsConfiguration;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.AxonThreadFactory;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.EventProcessingConfigurer;
import org.axonframework.config.LegacyConfiguration;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.async.SequencingPolicy;
import org.axonframework.eventhandling.async.SequentialPerAggregatePolicy;
import org.axonframework.eventsourcing.Snapshotter;
import org.axonframework.eventsourcing.SnapshotterSpanFactory;
import org.axonframework.eventsourcing.eventstore.LegacyEventStore;
import org.axonframework.messaging.StreamableMessageSource;
import org.axonframework.messaging.SubscribableMessageSource;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.spring.eventsourcing.SpringAggregateSnapshotter;
import org.axonframework.springboot.DistributedCommandBusProperties;
import org.axonframework.springboot.EventProcessorProperties;
import org.axonframework.springboot.TagsConfigurationProperties;
import org.axonframework.springboot.autoconfig.EventProcessingAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@AutoConfigureAfter(value={EventProcessingAutoConfiguration.class})
@EnableConfigurationProperties(value={EventProcessorProperties.class, DistributedCommandBusProperties.class, TagsConfigurationProperties.class})
public class LegacyAxonAutoConfiguration {
    private final EventProcessorProperties eventProcessorProperties;
    private final TagsConfigurationProperties tagsConfigurationProperties;

    public LegacyAxonAutoConfiguration(EventProcessorProperties eventProcessorProperties, TagsConfigurationProperties tagsConfigurationProperties) {
        this.eventProcessorProperties = eventProcessorProperties;
        this.tagsConfigurationProperties = tagsConfigurationProperties;
    }

    @Bean
    public TagsConfiguration tagsConfiguration() {
        return this.tagsConfigurationProperties.toTagsConfiguration();
    }

    @ConditionalOnMissingBean(value={Snapshotter.class})
    @ConditionalOnBean(value={LegacyEventStore.class})
    @Bean
    public SpringAggregateSnapshotter aggregateSnapshotter(LegacyConfiguration configuration, HandlerDefinition handlerDefinition, ParameterResolverFactory parameterResolverFactory, LegacyEventStore eventStore, TransactionManager transactionManager, SnapshotterSpanFactory spanFactory) {
        return SpringAggregateSnapshotter.builder().repositoryProvider(arg_0 -> ((LegacyConfiguration)configuration).repository(arg_0)).transactionManager(transactionManager).eventStore(eventStore).parameterResolverFactory(parameterResolverFactory).handlerDefinition(handlerDefinition).spanFactory(spanFactory).build();
    }

    @Autowired
    public void configureEventHandling(EventProcessingConfigurer eventProcessingConfigurer, ApplicationContext applicationContext) {
        this.eventProcessorProperties.getProcessors().forEach((name, settings) -> {
            Function<LegacyConfiguration, SequencingPolicy> sequencingPolicy = this.resolveSequencingPolicy(applicationContext, (EventProcessorProperties.ProcessorSettings)settings);
            eventProcessingConfigurer.registerSequencingPolicy(name, sequencingPolicy);
            if (settings.getMode() == EventProcessorProperties.Mode.POOLED) {
                eventProcessingConfigurer.registerPooledStreamingEventProcessor(name, this.resolveMessageSource(applicationContext, (EventProcessorProperties.ProcessorSettings)settings), (config, builder) -> {
                    ScheduledExecutorService workerExecutor = Executors.newScheduledThreadPool(settings.getThreadCount(), (ThreadFactory)new AxonThreadFactory("WorkPackage[" + name + "]"));
                    config.onShutdown(workerExecutor::shutdown);
                    return builder.workerExecutor(workerExecutor).initialSegmentCount(this.initialSegmentCount((EventProcessorProperties.ProcessorSettings)settings, 16)).tokenClaimInterval(this.tokenClaimIntervalMillis((EventProcessorProperties.ProcessorSettings)settings)).batchSize(settings.getBatchSize());
                });
            } else if (settings.getSource() == null) {
                eventProcessingConfigurer.registerSubscribingEventProcessor(name);
            } else {
                eventProcessingConfigurer.registerSubscribingEventProcessor(name, c -> {
                    Object bean = applicationContext.getBean(settings.getSource());
                    if (bean instanceof SubscribableMessageSource) {
                        return (SubscribableMessageSource)bean;
                    }
                    throw new AxonConfigurationException(String.format("Invalid message source [%s] configured for Event Processor [%s]. The message source should be a SubscribableMessageSource or SubscribableMessageSourceFactory", settings.getSource(), name));
                });
            }
            if (settings.getDlq().getCache().isEnabled()) {
                eventProcessingConfigurer.registerDeadLetteringEventHandlerInvokerConfiguration(name, (c, builder) -> builder.enableSequenceIdentifierCache().sequenceIdentifierCacheSize(settings.getDlq().getCache().getSize()));
            }
        });
    }

    private int initialSegmentCount(EventProcessorProperties.ProcessorSettings settings, int defaultCount) {
        return settings.getInitialSegmentCount() != null ? settings.getInitialSegmentCount() : defaultCount;
    }

    private long tokenClaimIntervalMillis(EventProcessorProperties.ProcessorSettings settings) {
        return settings.getTokenClaimIntervalTimeUnit().toMillis(settings.getTokenClaimInterval());
    }

    private Function<LegacyConfiguration, StreamableMessageSource<TrackedEventMessage>> resolveMessageSource(ApplicationContext applicationContext, EventProcessorProperties.ProcessorSettings v) {
        Function<LegacyConfiguration, Object> messageSource = v.getSource() == null ? LegacyConfiguration::eventStore : c -> (StreamableMessageSource)applicationContext.getBean(v.getSource(), StreamableMessageSource.class);
        return messageSource;
    }

    private Function<LegacyConfiguration, SequencingPolicy> resolveSequencingPolicy(ApplicationContext applicationContext, EventProcessorProperties.ProcessorSettings v) {
        Function<LegacyConfiguration, SequencingPolicy> sequencingPolicy = v.getSequencingPolicy() != null ? c -> (SequencingPolicy)applicationContext.getBean(v.getSequencingPolicy(), SequencingPolicy.class) : c -> SequentialPerAggregatePolicy.instance();
        return sequencingPolicy;
    }
}

