/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.autoconfig;

import com.codahale.metrics.MetricRegistry;
import org.axonframework.metrics.GlobalMetricRegistry;
import org.axonframework.metrics.MetricsConfigurerModule;
import org.axonframework.springboot.MetricsProperties;
import org.axonframework.springboot.autoconfig.LegacyAxonAutoConfiguration;
import org.axonframework.springboot.autoconfig.MicrometerMetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@AutoConfigureBefore(value={LegacyAxonAutoConfiguration.class})
@ConditionalOnMissingBean(value={MicrometerMetricsAutoConfiguration.class})
@ConditionalOnClass(name={"com.codahale.metrics.MetricRegistry", "org.axonframework.metrics.GlobalMetricRegistry"})
@EnableConfigurationProperties(value={MetricsProperties.class})
public class MetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={MetricRegistry.class})
    public static MetricRegistry metricRegistry() {
        return new MetricRegistry();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={MetricRegistry.class})
    public static GlobalMetricRegistry globalMetricRegistry(MetricRegistry metricRegistry) {
        return new GlobalMetricRegistry(metricRegistry);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={GlobalMetricRegistry.class})
    @ConditionalOnProperty(value={"axon.metrics.auto-configuration.enabled"}, matchIfMissing=true)
    public static MetricsConfigurerModule metricsConfigurerModule(GlobalMetricRegistry globalMetricRegistry) {
        return new MetricsConfigurerModule(globalMetricRegistry);
    }
}

