/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.autoconfig;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.config.LegacyConfigurer;
import org.axonframework.config.ModuleConfiguration;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.modelling.saga.ResourceInjector;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.axonframework.spring.config.MessageHandlerLookup;
import org.axonframework.spring.config.SpringAggregateLookup;
import org.axonframework.spring.config.SpringAxonConfiguration;
import org.axonframework.spring.config.SpringConfigurer;
import org.axonframework.spring.config.SpringSagaLookup;
import org.axonframework.spring.config.annotation.HandlerDefinitionFactoryBean;
import org.axonframework.spring.config.annotation.SpringParameterResolverFactoryBean;
import org.axonframework.spring.saga.SpringResourceInjector;
import org.axonframework.springboot.autoconfig.JpaAutoConfiguration;
import org.axonframework.springboot.autoconfig.JpaEventStoreAutoConfiguration;
import org.axonframework.springboot.autoconfig.LegacyAxonAutoConfiguration;
import org.axonframework.springboot.autoconfig.NoOpTransactionAutoConfiguration;
import org.axonframework.springboot.autoconfig.TransactionAutoConfiguration;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

@AutoConfiguration
@ConditionalOnClass(value={SpringConfigurer.class})
@AutoConfigureAfter(value={LegacyAxonAutoConfiguration.class, JpaAutoConfiguration.class, JpaEventStoreAutoConfiguration.class, NoOpTransactionAutoConfiguration.class, TransactionAutoConfiguration.class})
public class InfraConfiguration {
    @Role(value=2)
    @Bean
    public static MessageHandlerLookup messageHandlerLookup() {
        return new MessageHandlerLookup();
    }

    @Role(value=2)
    @Bean
    public static SpringAggregateLookup springAggregateLookup() {
        return new SpringAggregateLookup();
    }

    @Role(value=2)
    @Bean
    public static SpringSagaLookup springSagaLookup() {
        return new SpringSagaLookup();
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringAxonConfiguration springAxonConfiguration(LegacyConfigurer configurer) {
        return new SpringAxonConfiguration(configurer);
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringConfigurer springAxonConfigurer(ConfigurableListableBeanFactory beanFactory, List<ConfigurerModule> configurerModules, List<ModuleConfiguration> moduleConfigurations) {
        SpringConfigurer configurer = new SpringConfigurer(beanFactory);
        moduleConfigurations.forEach(arg_0 -> ((SpringConfigurer)configurer).registerModule(arg_0));
        ArrayList<ConfigurerModule> sortedList = new ArrayList<ConfigurerModule>(configurerModules);
        sortedList.sort(Comparator.comparing(ConfigurerModule::order).thenComparing((Comparator<ConfigurerModule>)AnnotationAwareOrderComparator.INSTANCE));
        sortedList.forEach(c -> c.configureModule((LegacyConfigurer)configurer));
        return configurer;
    }

    @Primary
    @Bean
    public HandlerDefinitionFactoryBean handlerDefinition(List<HandlerDefinition> handlerDefinitions, List<HandlerEnhancerDefinition> handlerEnhancerDefinitions) {
        return new HandlerDefinitionFactoryBean(handlerDefinitions, handlerEnhancerDefinitions);
    }

    @Primary
    @Bean
    public SpringParameterResolverFactoryBean parameterResolverFactory(List<ParameterResolverFactory> parameterResolverFactories) {
        SpringParameterResolverFactoryBean springParameterResolverFactoryBean = new SpringParameterResolverFactoryBean();
        springParameterResolverFactoryBean.setAdditionalFactories(parameterResolverFactories);
        return springParameterResolverFactoryBean;
    }

    @ConditionalOnClass(value={CorrelationDataProvider.class})
    @Bean
    public ConfigurerModule correlationDataProvidersConfigurer(List<CorrelationDataProvider> correlationDataProviders) {
        return configurer -> configurer.configureCorrelationDataProviders(c -> correlationDataProviders);
    }

    @ConditionalOnClass(value={EventUpcaster.class})
    @Bean
    public ConfigurerModule eventUpcastersConfigurer(List<EventUpcaster> upcasters) {
        return configurer -> upcasters.forEach(u -> configurer.registerEventUpcaster(c -> u));
    }

    @ConditionalOnMissingBean
    @Bean
    public ResourceInjector resourceInjector() {
        return new SpringResourceInjector();
    }
}

