/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.autoconfig;

import jakarta.annotation.Nonnull;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.config.LegacyConfiguration;
import org.axonframework.config.LegacyConfigurer;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.timeout.HandlerTimeoutHandlerEnhancerDefinition;
import org.axonframework.messaging.timeout.TaskTimeoutSettings;
import org.axonframework.messaging.timeout.UnitOfWorkTimeoutInterceptor;
import org.axonframework.springboot.TimeoutProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={TimeoutProperties.class})
@ConditionalOnProperty(prefix="axon.timeout", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class AxonTimeoutAutoConfiguration {
    @Bean
    public HandlerTimeoutHandlerEnhancerDefinition messageTimeoutHandlerEnhancerDefinition(TimeoutProperties properties) {
        return new HandlerTimeoutHandlerEnhancerDefinition(properties.getHandler().toMessageHandlerTimeoutConfiguration());
    }

    @Bean
    public ConfigurerModule axonTimeoutConfigurerModule(TimeoutProperties properties) {
        return new AxonTimeoutConfigurerModule(properties);
    }

    private static class AxonTimeoutConfigurerModule
    implements ConfigurerModule {
        private final TimeoutProperties.TransactionTimeoutProperties properties;

        public AxonTimeoutConfigurerModule(TimeoutProperties properties) {
            this.properties = properties.getTransaction();
        }

        public void configureModule(@Nonnull LegacyConfigurer configurer) {
            configurer.eventProcessing().registerDefaultHandlerInterceptor((c, name) -> {
                TaskTimeoutSettings settings = this.getSettingsForProcessor((String)name);
                return new UnitOfWorkTimeoutInterceptor("EventProcessor " + name, settings.getTimeoutMs(), settings.getWarningThresholdMs(), settings.getWarningIntervalMs());
            });
            configurer.onStart(Integer.MIN_VALUE, () -> {
                LegacyConfiguration c = configurer.buildConfiguration();
                c.queryBus().registerHandlerInterceptor((MessageHandlerInterceptor)new UnitOfWorkTimeoutInterceptor(c.queryBus().getClass().getSimpleName(), this.properties.getQueryBus().getTimeoutMs(), this.properties.getQueryBus().getWarningThresholdMs(), this.properties.getQueryBus().getWarningIntervalMs()));
                c.deadlineManager().registerHandlerInterceptor((MessageHandlerInterceptor)new UnitOfWorkTimeoutInterceptor(c.deadlineManager().getClass().getSimpleName(), this.properties.getDeadline().getTimeoutMs(), this.properties.getDeadline().getWarningThresholdMs(), this.properties.getDeadline().getWarningIntervalMs()));
            });
        }

        private TaskTimeoutSettings getSettingsForProcessor(String name) {
            return this.properties.getEventProcessor().getOrDefault(name, this.properties.getEventProcessors());
        }

        public int order() {
            return Integer.MIN_VALUE;
        }
    }
}

