/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.autoconfig;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.thoughtworks.xstream.XStream;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.DuplicateCommandHandlerResolver;
import org.axonframework.commandhandling.LoggingDuplicateCommandHandlerResolver;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.gateway.DefaultCommandGateway;
import org.axonframework.common.AxonThreadFactory;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.Configuration;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.config.EventProcessingConfigurer;
import org.axonframework.config.TagsConfiguration;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.SimpleEventBus;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingEventProcessorConfiguration;
import org.axonframework.eventhandling.async.SequencingPolicy;
import org.axonframework.eventhandling.async.SequentialPerAggregatePolicy;
import org.axonframework.eventhandling.gateway.DefaultEventGateway;
import org.axonframework.eventhandling.gateway.EventGateway;
import org.axonframework.eventsourcing.Snapshotter;
import org.axonframework.eventsourcing.eventstore.EmbeddedEventStore;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.StreamableMessageSource;
import org.axonframework.messaging.SubscribableMessageSource;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.messaging.correlation.MessageOriginProvider;
import org.axonframework.messaging.interceptors.CorrelationDataInterceptor;
import org.axonframework.queryhandling.DefaultQueryGateway;
import org.axonframework.queryhandling.LoggingQueryInvocationErrorHandler;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryGateway;
import org.axonframework.queryhandling.QueryInvocationErrorHandler;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.queryhandling.SimpleQueryBus;
import org.axonframework.queryhandling.SimpleQueryUpdateEmitter;
import org.axonframework.serialization.AnnotationRevisionResolver;
import org.axonframework.serialization.ChainingConverter;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.JavaSerializer;
import org.axonframework.serialization.RevisionResolver;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.json.JacksonSerializer;
import org.axonframework.serialization.xml.XStreamSerializer;
import org.axonframework.spring.eventsourcing.SpringAggregateSnapshotter;
import org.axonframework.springboot.DistributedCommandBusProperties;
import org.axonframework.springboot.EventProcessorProperties;
import org.axonframework.springboot.SerializerProperties;
import org.axonframework.springboot.TagsConfigurationProperties;
import org.axonframework.springboot.autoconfig.EventProcessingAutoConfiguration;
import org.axonframework.springboot.util.ConditionalOnMissingQualifiedBean;
import org.axonframework.tracing.SpanFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@org.springframework.context.annotation.Configuration
@AutoConfigureAfter(value={EventProcessingAutoConfiguration.class})
@EnableConfigurationProperties(value={EventProcessorProperties.class, DistributedCommandBusProperties.class, SerializerProperties.class, TagsConfigurationProperties.class})
public class AxonAutoConfiguration
implements BeanClassLoaderAware {
    private final EventProcessorProperties eventProcessorProperties;
    private final SerializerProperties serializerProperties;
    private final TagsConfigurationProperties tagsConfigurationProperties;
    private final ApplicationContext applicationContext;
    private ClassLoader beanClassLoader;

    public AxonAutoConfiguration(EventProcessorProperties eventProcessorProperties, SerializerProperties serializerProperties, TagsConfigurationProperties tagsConfigurationProperties, ApplicationContext applicationContext) {
        this.eventProcessorProperties = eventProcessorProperties;
        this.serializerProperties = serializerProperties;
        this.tagsConfigurationProperties = tagsConfigurationProperties;
        this.applicationContext = applicationContext;
    }

    @Bean
    public TagsConfiguration tagsConfiguration() {
        return this.tagsConfigurationProperties.toTagsConfiguration();
    }

    @Bean
    @ConditionalOnMissingBean
    public RevisionResolver revisionResolver() {
        return new AnnotationRevisionResolver();
    }

    @Bean
    @Primary
    @ConditionalOnMissingQualifiedBean(beanClass=Serializer.class, qualifier="!eventSerializer,messageSerializer")
    public Serializer serializer(RevisionResolver revisionResolver) {
        return this.buildSerializer(revisionResolver, this.serializerProperties.getGeneral());
    }

    @Bean
    @Qualifier(value="messageSerializer")
    @ConditionalOnMissingQualifiedBean(beanClass=Serializer.class, qualifier="messageSerializer")
    public Serializer messageSerializer(Serializer genericSerializer, RevisionResolver revisionResolver) {
        if (SerializerProperties.SerializerType.DEFAULT.equals((Object)this.serializerProperties.getMessages()) || this.serializerProperties.getGeneral().equals((Object)this.serializerProperties.getMessages())) {
            return genericSerializer;
        }
        return this.buildSerializer(revisionResolver, this.serializerProperties.getMessages());
    }

    @Bean
    @Qualifier(value="eventSerializer")
    @ConditionalOnMissingQualifiedBean(beanClass=Serializer.class, qualifier="eventSerializer")
    public Serializer eventSerializer(@Qualifier(value="messageSerializer") Serializer messageSerializer, Serializer generalSerializer, RevisionResolver revisionResolver) {
        if (SerializerProperties.SerializerType.DEFAULT.equals((Object)this.serializerProperties.getEvents()) || this.serializerProperties.getEvents().equals((Object)this.serializerProperties.getMessages())) {
            return messageSerializer;
        }
        if (this.serializerProperties.getGeneral().equals((Object)this.serializerProperties.getEvents())) {
            return generalSerializer;
        }
        return this.buildSerializer(revisionResolver, this.serializerProperties.getEvents());
    }

    @Bean
    public ConfigurerModule serializerConfigurer(@Qualifier(value="eventSerializer") Serializer eventSerializer, @Qualifier(value="messageSerializer") Serializer messageSerializer, Serializer generalSerializer) {
        return configurer -> {
            configurer.configureEventSerializer(c -> eventSerializer);
            configurer.configureMessageSerializer(c -> messageSerializer);
            configurer.configureSerializer(c -> generalSerializer);
        };
    }

    private Serializer buildSerializer(RevisionResolver revisionResolver, SerializerProperties.SerializerType serializerType) {
        switch (serializerType) {
            case JACKSON: {
                Map objectMapperBeans = this.applicationContext.getBeansOfType(ObjectMapper.class);
                ObjectMapper objectMapper = objectMapperBeans.containsKey("defaultAxonObjectMapper") ? (ObjectMapper)objectMapperBeans.get("defaultAxonObjectMapper") : (ObjectMapper)objectMapperBeans.values().stream().findFirst().orElseThrow(() -> new NoSuchBeanDefinitionException(ObjectMapper.class));
                ChainingConverter converter = new ChainingConverter(this.beanClassLoader);
                return JacksonSerializer.builder().revisionResolver(revisionResolver).converter((Converter)converter).objectMapper(objectMapper).build();
            }
            case JAVA: {
                return JavaSerializer.builder().revisionResolver(revisionResolver).build();
            }
        }
        Map xStreamBeans = this.applicationContext.getBeansOfType(XStream.class);
        XStream xStream = xStreamBeans.containsKey("defaultAxonXStream") ? (XStream)xStreamBeans.get("defaultAxonXStream") : (XStream)xStreamBeans.values().stream().findFirst().orElseThrow(() -> new NoSuchBeanDefinitionException(XStream.class));
        return XStreamSerializer.builder().xStream(xStream).revisionResolver(revisionResolver).classLoader(this.beanClassLoader).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public CorrelationDataProvider messageOriginProvider() {
        return new MessageOriginProvider();
    }

    @Qualifier(value="eventStore")
    @Bean(name={"eventBus"})
    @ConditionalOnMissingBean(value={EventBus.class})
    @ConditionalOnBean(value={EventStorageEngine.class})
    public EmbeddedEventStore eventStore(EventStorageEngine storageEngine, Configuration configuration) {
        return EmbeddedEventStore.builder().storageEngine(storageEngine).messageMonitor(configuration.messageMonitor(EventStore.class, "eventStore")).spanFactory(configuration.spanFactory()).build();
    }

    @ConditionalOnMissingBean
    @Bean
    public CommandGateway commandGateway(CommandBus commandBus) {
        return DefaultCommandGateway.builder().commandBus(commandBus).build();
    }

    @ConditionalOnMissingBean
    @Bean
    public QueryGateway queryGateway(QueryBus queryBus) {
        return DefaultQueryGateway.builder().queryBus(queryBus).build();
    }

    @Bean
    @ConditionalOnMissingBean(value={EventStorageEngine.class, EventBus.class})
    public SimpleEventBus eventBus(Configuration configuration) {
        return SimpleEventBus.builder().messageMonitor(configuration.messageMonitor(EventStore.class, "eventStore")).spanFactory(configuration.spanFactory()).build();
    }

    @ConditionalOnMissingBean
    @Bean
    public EventGateway eventGateway(EventBus eventBus) {
        return DefaultEventGateway.builder().eventBus(eventBus).build();
    }

    @ConditionalOnMissingBean(value={Snapshotter.class})
    @ConditionalOnBean(value={EventStore.class})
    @Bean
    public SpringAggregateSnapshotter aggregateSnapshotter(Configuration configuration, HandlerDefinition handlerDefinition, ParameterResolverFactory parameterResolverFactory, EventStore eventStore, TransactionManager transactionManager, SpanFactory spanFactory) {
        return SpringAggregateSnapshotter.builder().repositoryProvider(arg_0 -> ((Configuration)configuration).repository(arg_0)).transactionManager(transactionManager).eventStore(eventStore).parameterResolverFactory(parameterResolverFactory).handlerDefinition(handlerDefinition).spanFactory(spanFactory).build();
    }

    @Autowired
    public void configureEventHandling(EventProcessingConfigurer eventProcessingConfigurer, ApplicationContext applicationContext) {
        this.eventProcessorProperties.getProcessors().forEach((name, settings) -> {
            Function<Configuration, SequencingPolicy<? super EventMessage<?>>> sequencingPolicy = this.resolveSequencingPolicy(applicationContext, (EventProcessorProperties.ProcessorSettings)settings);
            eventProcessingConfigurer.registerSequencingPolicy(name, sequencingPolicy);
            if (settings.getMode() == EventProcessorProperties.Mode.TRACKING) {
                TrackingEventProcessorConfiguration config2 = TrackingEventProcessorConfiguration.forParallelProcessing((int)settings.getThreadCount()).andBatchSize(settings.getBatchSize()).andInitialSegmentsCount(this.initialSegmentCount((EventProcessorProperties.ProcessorSettings)settings, 1)).andTokenClaimInterval(settings.getTokenClaimInterval(), settings.getTokenClaimIntervalTimeUnit());
                Function<Configuration, StreamableMessageSource<TrackedEventMessage<?>>> messageSource = this.resolveMessageSource(applicationContext, (EventProcessorProperties.ProcessorSettings)settings);
                eventProcessingConfigurer.registerTrackingEventProcessor(name, messageSource, c -> config2);
            } else if (settings.getMode() == EventProcessorProperties.Mode.POOLED) {
                eventProcessingConfigurer.registerPooledStreamingEventProcessor(name, this.resolveMessageSource(applicationContext, (EventProcessorProperties.ProcessorSettings)settings), (config, builder) -> {
                    ScheduledExecutorService workerExecutor = Executors.newScheduledThreadPool(settings.getThreadCount(), (ThreadFactory)new AxonThreadFactory("WorkPackage[" + name + "]"));
                    config.onShutdown(workerExecutor::shutdown);
                    return builder.workerExecutor(workerExecutor).initialSegmentCount(this.initialSegmentCount((EventProcessorProperties.ProcessorSettings)settings, 16)).tokenClaimInterval(this.tokenClaimIntervalMillis((EventProcessorProperties.ProcessorSettings)settings)).batchSize(settings.getBatchSize());
                });
            } else if (settings.getSource() == null) {
                eventProcessingConfigurer.registerSubscribingEventProcessor(name);
            } else {
                eventProcessingConfigurer.registerSubscribingEventProcessor(name, c -> (SubscribableMessageSource)applicationContext.getBean(settings.getSource(), SubscribableMessageSource.class));
            }
        });
    }

    private int initialSegmentCount(EventProcessorProperties.ProcessorSettings settings, int defaultCount) {
        return settings.getInitialSegmentCount() != null ? settings.getInitialSegmentCount() : defaultCount;
    }

    private long tokenClaimIntervalMillis(EventProcessorProperties.ProcessorSettings settings) {
        return settings.getTokenClaimIntervalTimeUnit().toMillis(settings.getTokenClaimInterval());
    }

    private Function<Configuration, StreamableMessageSource<TrackedEventMessage<?>>> resolveMessageSource(ApplicationContext applicationContext, EventProcessorProperties.ProcessorSettings v) {
        Function<Configuration, Object> messageSource = v.getSource() == null ? Configuration::eventStore : c -> (StreamableMessageSource)applicationContext.getBean(v.getSource(), StreamableMessageSource.class);
        return messageSource;
    }

    private Function<Configuration, SequencingPolicy<? super EventMessage<?>>> resolveSequencingPolicy(ApplicationContext applicationContext, EventProcessorProperties.ProcessorSettings v) {
        Function<Configuration, Object> sequencingPolicy = v.getSequencingPolicy() != null ? c -> (SequencingPolicy)applicationContext.getBean(v.getSequencingPolicy(), SequencingPolicy.class) : c -> SequentialPerAggregatePolicy.instance();
        return sequencingPolicy;
    }

    @Bean
    @ConditionalOnMissingBean
    public DuplicateCommandHandlerResolver duplicateCommandHandlerResolver() {
        return LoggingDuplicateCommandHandlerResolver.instance();
    }

    @ConditionalOnMissingBean(ignoredType={"org.axonframework.commandhandling.distributed.DistributedCommandBus", "org.axonframework.axonserver.connector.command.AxonServerCommandBus", "org.axonframework.extensions.multitenancy.components.commandhandeling.MultiTenantCommandBus"}, value={CommandBus.class})
    @Qualifier(value="localSegment")
    @Bean
    public SimpleCommandBus commandBus(TransactionManager txManager, Configuration axonConfiguration, DuplicateCommandHandlerResolver duplicateCommandHandlerResolver) {
        SimpleCommandBus commandBus = SimpleCommandBus.builder().transactionManager(txManager).duplicateCommandHandlerResolver(duplicateCommandHandlerResolver).spanFactory(axonConfiguration.spanFactory()).messageMonitor(axonConfiguration.messageMonitor(CommandBus.class, "commandBus")).build();
        commandBus.registerHandlerInterceptor((MessageHandlerInterceptor)new CorrelationDataInterceptor((Collection)axonConfiguration.correlationDataProviders()));
        return commandBus;
    }

    @ConditionalOnMissingBean(value={QueryBus.class})
    @Qualifier(value="localSegment")
    @Bean
    public SimpleQueryBus queryBus(Configuration axonConfiguration, TransactionManager transactionManager) {
        return SimpleQueryBus.builder().messageMonitor(axonConfiguration.messageMonitor(QueryBus.class, "queryBus")).transactionManager(transactionManager).errorHandler((QueryInvocationErrorHandler)axonConfiguration.getComponent(QueryInvocationErrorHandler.class, () -> LoggingQueryInvocationErrorHandler.builder().build())).queryUpdateEmitter((QueryUpdateEmitter)axonConfiguration.getComponent(QueryUpdateEmitter.class)).spanFactory(axonConfiguration.spanFactory()).build();
    }

    @Bean
    public QueryUpdateEmitter queryUpdateEmitter(Configuration configuration) {
        return SimpleQueryUpdateEmitter.builder().updateMessageMonitor(configuration.messageMonitor(QueryUpdateEmitter.class, "queryUpdateEmitter")).spanFactory(configuration.spanFactory()).build();
    }

    public void setBeanClassLoader(@Nonnull ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }
}

