/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.util;

import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.ApplicationContext;

public abstract class XStreamSecurityTypeUtility {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String PACKAGES_AND_SUBPACKAGES_WILDCARD = ".**";

    public static String[] autoConfigBasePackages(ApplicationContext applicationContext) {
        if (AutoConfigurationPackages.has((BeanFactory)applicationContext)) {
            return (String[])AutoConfigurationPackages.get((BeanFactory)applicationContext).stream().map(basePackage -> {
                logger.info("Constructing wildcard type for base package [{}].", basePackage);
                return basePackage + PACKAGES_AND_SUBPACKAGES_WILDCARD;
            }).toArray(String[]::new);
        }
        logger.warn("Cannot extract types, because the provided ApplicationContext does not contain any @EnableAutoConfiguration annotated beans.");
        return new String[0];
    }

    private XStreamSecurityTypeUtility() {
    }
}

