/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="axon.eventhandling")
public class EventProcessorProperties {
    private final Map<String, ProcessorSettings> processors = new HashMap<String, ProcessorSettings>();

    public Map<String, ProcessorSettings> getProcessors() {
        return this.processors;
    }

    public static class DlqCache {
        private boolean enabled = false;
        private int size = 1024;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }
    }

    public static class Dlq {
        private boolean enabled = false;
        private DlqCache cache = new DlqCache();

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public DlqCache getCache() {
            return this.cache;
        }

        public void setCache(DlqCache cache) {
            this.cache = cache;
        }
    }

    public static class ProcessorSettings {
        private String source;
        private Mode mode = Mode.TRACKING;
        private Integer initialSegmentCount = null;
        private long tokenClaimInterval = 5000L;
        private TimeUnit tokenClaimIntervalTimeUnit = TimeUnit.MILLISECONDS;
        private int threadCount = -1;
        private int batchSize = 1;
        private String sequencingPolicy;
        private Dlq dlq = new Dlq();

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public Mode getMode() {
            return this.mode;
        }

        public void setMode(Mode mode) {
            this.mode = mode;
        }

        public Integer getInitialSegmentCount() {
            return this.initialSegmentCount;
        }

        public void setInitialSegmentCount(Integer initialSegmentCount) {
            this.initialSegmentCount = initialSegmentCount;
        }

        public long getTokenClaimInterval() {
            return this.tokenClaimInterval;
        }

        public void setTokenClaimInterval(long tokenClaimInterval) {
            this.tokenClaimInterval = tokenClaimInterval;
        }

        public TimeUnit getTokenClaimIntervalTimeUnit() {
            return this.tokenClaimIntervalTimeUnit;
        }

        public void setTokenClaimIntervalTimeUnit(TimeUnit tokenClaimIntervalTimeUnit) {
            this.tokenClaimIntervalTimeUnit = tokenClaimIntervalTimeUnit;
        }

        public int getThreadCount() {
            int defaultThreadCount = 1;
            if (this.mode == Mode.TRACKING) {
                defaultThreadCount = this.initialSegmentCount != null ? this.initialSegmentCount : 1;
            } else if (this.mode == Mode.POOLED) {
                defaultThreadCount = this.initialSegmentCount != null ? this.initialSegmentCount : 4;
            }
            return this.threadCount < 0 ? defaultThreadCount : this.threadCount;
        }

        public void setThreadCount(int threadCount) {
            this.threadCount = threadCount;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public void setBatchSize(int batchSize) {
            this.batchSize = batchSize;
        }

        public String getSequencingPolicy() {
            return this.sequencingPolicy;
        }

        public void setSequencingPolicy(String sequencingPolicy) {
            this.sequencingPolicy = sequencingPolicy;
        }

        public Dlq getDlq() {
            return this.dlq;
        }

        public void setDlq(Dlq dlq) {
            this.dlq = dlq;
        }
    }

    public static enum Mode {
        TRACKING,
        SUBSCRIBING,
        POOLED;

    }
}

