/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.autoconfig;

import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.Configuration;
import org.axonframework.config.ConfigurationScopeAwareProvider;
import org.axonframework.deadline.DeadlineManager;
import org.axonframework.deadline.DeadlineManagerSpanFactory;
import org.axonframework.deadline.jobrunr.JobRunrDeadlineManager;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.scheduling.EventScheduler;
import org.axonframework.eventhandling.scheduling.jobrunr.JobRunrEventScheduler;
import org.axonframework.messaging.ScopeAwareProvider;
import org.axonframework.serialization.Serializer;
import org.axonframework.springboot.autoconfig.AxonServerAutoConfiguration;
import org.axonframework.springboot.autoconfig.AxonTracingAutoConfiguration;
import org.jobrunr.scheduling.JobScheduler;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnBean(value={JobScheduler.class})
@AutoConfigureAfter(value={AxonServerAutoConfiguration.class, AxonTracingAutoConfiguration.class}, name={"org.jobrunr.spring.autoconfigure.JobRunrAutoConfiguration"})
public class AxonJobRunrAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public EventScheduler eventScheduler(JobScheduler jobScheduler, @Qualifier(value="eventSerializer") Serializer serializer, TransactionManager transactionManager, EventBus eventBus) {
        return JobRunrEventScheduler.builder().jobScheduler(jobScheduler).serializer(serializer).transactionManager(transactionManager).eventBus(eventBus).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public DeadlineManager deadlineManager(JobScheduler jobScheduler, Configuration configuration, @Qualifier(value="eventSerializer") Serializer serializer, TransactionManager transactionManager, DeadlineManagerSpanFactory spanFactory) {
        ConfigurationScopeAwareProvider scopeAwareProvider = new ConfigurationScopeAwareProvider(configuration);
        return JobRunrDeadlineManager.builder().jobScheduler(jobScheduler).scopeAwareProvider((ScopeAwareProvider)scopeAwareProvider).serializer(serializer).transactionManager(transactionManager).spanFactory(spanFactory).build();
    }
}

