/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.boot.util;

import java.util.stream.Stream;
import org.axonframework.boot.util.OnQualifiedBeanCondition;
import org.axonframework.spring.SpringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.MultiValueMap;

public abstract class AbstractQualifiedBeanCondition
extends SpringBootCondition
implements ConfigurationCondition {
    private static final Logger logger = LoggerFactory.getLogger(OnQualifiedBeanCondition.class);
    private final String annotationName;
    private final String beanClassAttribute;
    private final String qualifierAttribute;

    public AbstractQualifiedBeanCondition(String annotationName, String beanClassAttribute, String qualifierAttribute) {
        this.annotationName = annotationName;
        this.beanClassAttribute = beanClassAttribute;
        this.qualifierAttribute = qualifierAttribute;
    }

    public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
        return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Class<?> conditionalClass;
        boolean qualifierMatch;
        String qualifier;
        MultiValueMap annotationAttributes = metadata.getAllAnnotationAttributes(this.annotationName, true);
        String beanType = (String)annotationAttributes.getFirst((Object)this.beanClassAttribute);
        String qualifierAttr = (String)annotationAttributes.getFirst((Object)this.qualifierAttribute);
        if (qualifierAttr.startsWith("!")) {
            qualifier = qualifierAttr.substring(1);
            qualifierMatch = false;
        } else {
            qualifier = qualifierAttr;
            qualifierMatch = true;
        }
        try {
            conditionalClass = Class.forName(beanType);
        }
        catch (ClassNotFoundException e) {
            String failureMessage = String.format("Failed to extract a class instance for fully qualified class name [%s]", beanType);
            logger.warn(failureMessage, (Throwable)e);
            return new ConditionOutcome(false, failureMessage);
        }
        ConfigurableListableBeanFactory bf = context.getBeanFactory();
        boolean anyMatch = Stream.of(bf.getBeanNamesForType(conditionalClass)).anyMatch(beanName -> qualifierMatch == SpringUtils.isQualifierMatch((String)beanName, (ConfigurableListableBeanFactory)bf, (String)qualifier));
        String message = anyMatch ? String.format("Match found for class [%s] and qualifier [%s]", conditionalClass, qualifier) : String.format("No match found for class [%s] and qualifier [%s]", conditionalClass, qualifier);
        return this.buildOutcome(anyMatch, message);
    }

    protected abstract ConditionOutcome buildOutcome(boolean var1, String var2);
}

