/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.boot.autoconfig;

import org.axonframework.boot.autoconfig.JGroupsAutoConfiguration;
import org.axonframework.boot.autoconfig.JpaAutoConfiguration;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.distributed.AnnotationRoutingStrategy;
import org.axonframework.commandhandling.distributed.CommandBusConnector;
import org.axonframework.commandhandling.distributed.CommandRouter;
import org.axonframework.commandhandling.distributed.RoutingStrategy;
import org.axonframework.serialization.Serializer;
import org.axonframework.springcloud.commandhandling.SpringCloudCommandRouter;
import org.axonframework.springcloud.commandhandling.SpringHttpCommandBusConnector;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Configuration
@AutoConfigureAfter(value={JpaAutoConfiguration.class})
@AutoConfigureBefore(value={JGroupsAutoConfiguration.class})
@ConditionalOnProperty(value={"axon.distributed.enabled"})
@ConditionalOnClass(name={"org.axonframework.springcloud.commandhandling.SpringCloudCommandRouter", "org.axonframework.springcloud.commandhandling.SpringHttpCommandBusConnector", "org.springframework.cloud.client.discovery.DiscoveryClient", "org.springframework.web.client.RestTemplate"})
public class SpringCloudAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={DiscoveryClient.class})
    public CommandRouter springCloudCommandRouter(DiscoveryClient discoveryClient) {
        return new SpringCloudCommandRouter(discoveryClient, (RoutingStrategy)new AnnotationRoutingStrategy());
    }

    @Bean
    @ConditionalOnMissingBean
    public CommandBusConnector springHttpCommandBusConnector(@Qualifier(value="localSegment") CommandBus localSegment, RestTemplate restTemplate, Serializer serializer) {
        return new SpringHttpCommandBusConnector(localSegment, (RestOperations)restTemplate, serializer);
    }

    @Bean
    @ConditionalOnMissingBean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }
}

