/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.boot.autoconfig;

import java.sql.SQLException;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.axonframework.boot.RegisterDefaultEntities;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.common.jpa.ContainerManagedEntityManagerProvider;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.saga.repository.SagaStore;
import org.axonframework.eventhandling.saga.repository.jpa.JpaSagaStore;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.jpa.JpaTokenStore;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.jdbc.JdbcSQLErrorCodesResolver;
import org.axonframework.eventsourcing.eventstore.jpa.JpaEventStorageEngine;
import org.axonframework.eventsourcing.eventstore.jpa.SQLErrorCodesResolver;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.axonframework.spring.config.AxonConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnBean(value={EntityManagerFactory.class})
@RegisterDefaultEntities(packages={"org.axonframework.eventsourcing.eventstore.jpa", "org.axonframework.eventhandling.tokenstore", "org.axonframework.eventhandling.saga.repository.jpa"})
@Configuration
public class JpaAutoConfiguration {
    @ConditionalOnMissingBean
    @Bean
    public EventStorageEngine eventStorageEngine(Serializer serializer, PersistenceExceptionResolver persistenceExceptionResolver, AxonConfiguration configuration, EntityManagerProvider entityManagerProvider, TransactionManager transactionManager) {
        return new JpaEventStorageEngine(serializer, (EventUpcaster)configuration.getComponent(EventUpcaster.class), persistenceExceptionResolver, null, entityManagerProvider, transactionManager, null, null, true);
    }

    @ConditionalOnMissingBean
    @ConditionalOnBean(value={DataSource.class})
    @Bean
    public PersistenceExceptionResolver dataSourcePersistenceExceptionResolver(DataSource dataSource) throws SQLException {
        return new SQLErrorCodesResolver(dataSource);
    }

    @ConditionalOnMissingBean(value={DataSource.class, PersistenceExceptionResolver.class})
    @Bean
    public PersistenceExceptionResolver jdbcSQLErrorCodesResolver() {
        return new JdbcSQLErrorCodesResolver();
    }

    @ConditionalOnMissingBean
    @Bean
    public EntityManagerProvider entityManagerProvider() {
        return new ContainerManagedEntityManagerProvider();
    }

    @ConditionalOnMissingBean
    @Bean
    public TokenStore tokenStore(Serializer serializer, EntityManagerProvider entityManagerProvider) {
        return new JpaTokenStore(entityManagerProvider, serializer);
    }

    @ConditionalOnMissingBean(value={SagaStore.class})
    @Bean
    public JpaSagaStore sagaStore(Serializer serializer, EntityManagerProvider entityManagerProvider) {
        return new JpaSagaStore(serializer, entityManagerProvider);
    }
}

