/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.commandhandling.distributed.jgroups;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.distributed.AnnotationRoutingStrategy;
import org.axonframework.commandhandling.distributed.RoutingStrategy;
import org.axonframework.commandhandling.distributed.jgroups.ConnectionFailedException;
import org.axonframework.commandhandling.distributed.jgroups.JChannelFactory;
import org.axonframework.commandhandling.distributed.jgroups.JGroupsConnector;
import org.axonframework.commandhandling.distributed.jgroups.JGroupsXmlConfigurationChannelFactory;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.serialization.Serializer;
import org.jgroups.JChannel;
import org.jgroups.util.Util;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;

public class JGroupsConnectorFactoryBean
implements FactoryBean<JGroupsConnector>,
InitializingBean,
SmartLifecycle,
BeanNameAware,
ApplicationContextAware {
    private JGroupsConnector connector;
    private JChannelFactory channelFactory = new JGroupsXmlConfigurationChannelFactory("tcp_mcast.xml");
    private Serializer serializer;
    private String clusterName;
    private String channelName;
    private CommandBus localSegment;
    private JChannel channel;
    private int phase = Integer.MAX_VALUE;
    private String beanName;
    private ApplicationContext applicationContext;
    private List<MessageHandlerInterceptor<CommandMessage<?>>> interceptors;
    private long joinTimeout = -1L;
    private boolean registerMBean = false;
    private RoutingStrategy routingStrategy = new AnnotationRoutingStrategy();

    public JGroupsConnector getObject() throws Exception {
        return this.connector;
    }

    public Class<?> getObjectType() {
        return JGroupsConnector.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.localSegment == null) {
            SimpleCommandBus bus = new SimpleCommandBus();
            if (this.interceptors != null) {
                this.interceptors.forEach(arg_0 -> ((SimpleCommandBus)bus).registerHandlerInterceptor(arg_0));
            }
            this.localSegment = bus;
        }
        if (this.serializer == null) {
            this.serializer = (Serializer)this.applicationContext.getBean(Serializer.class);
        }
        if (this.clusterName == null) {
            this.clusterName = this.beanName;
        }
        this.channel = this.channelFactory.createChannel();
        if (this.channelName != null) {
            this.channel.setName(this.channelName);
        }
        this.connector = new JGroupsConnector(this.localSegment, this.channel, this.clusterName, this.serializer, this.routingStrategy);
    }

    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public void setConfiguration(String configuration) {
        this.channelFactory = new JGroupsXmlConfigurationChannelFactory(configuration);
    }

    public void setRoutingStrategy(RoutingStrategy routingStrategy) {
        this.routingStrategy = routingStrategy;
    }

    public void setChannelFactory(JChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public void setJoinTimeout(long joinTimeout) {
        this.joinTimeout = joinTimeout;
    }

    public void setLocalSegment(CommandBus localSegment) {
        this.localSegment = localSegment;
    }

    public void setInterceptors(List<MessageHandlerInterceptor<CommandMessage<?>>> interceptors) {
        this.interceptors = interceptors;
    }

    public void setRegisterMBean(boolean registerMBean) {
        this.registerMBean = registerMBean;
    }

    public void start() {
        try {
            this.connector.connect();
            if (this.joinTimeout >= 0L) {
                this.connector.awaitJoined(this.joinTimeout, TimeUnit.MILLISECONDS);
            } else {
                this.connector.awaitJoined();
            }
            if (this.registerMBean) {
                Util.registerChannel((JChannel)this.channel, null);
            }
        }
        catch (Exception e) {
            throw new ConnectionFailedException("Could not start JGroups Connector", (Throwable)e);
        }
    }

    public void stop() {
        this.channel.close();
    }

    public boolean isRunning() {
        return this.channel.isConnected();
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.channel.close();
        callback.run();
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

