/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.event;

import io.axoniq.axonserver.connector.event.EventStream;
import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.grpc.event.EventWithToken;
import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.function.Function;
import org.axonframework.common.StringUtils;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.processors.streaming.token.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.processors.streaming.token.TrackingToken;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.LegacyResources;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.SimpleEntry;

class AxonServerMessageStream
implements MessageStream<EventMessage> {
    private final EventStream stream;
    private final Function<Event, EventMessage> messageConverter;

    public AxonServerMessageStream(@Nonnull EventStream stream, @Nonnull Function<Event, EventMessage> messageConverter) {
        this.stream = stream;
        this.messageConverter = messageConverter;
    }

    public Optional<MessageStream.Entry<EventMessage>> next() {
        EventWithToken eventWithToken = (EventWithToken)this.stream.nextIfAvailable();
        if (eventWithToken == null) {
            return Optional.empty();
        }
        SimpleEntry<EventMessage> entry = this.toSimpleEntry(eventWithToken);
        return Optional.of(entry);
    }

    @Nonnull
    private SimpleEntry<EventMessage> toSimpleEntry(EventWithToken eventWithToken) {
        Event event = eventWithToken.getEvent();
        EventMessage message = this.messageConverter.apply(event);
        GlobalSequenceTrackingToken token = new GlobalSequenceTrackingToken(eventWithToken.getToken());
        Context context = Context.with((Context.ResourceKey)TrackingToken.RESOURCE_KEY, (Object)token);
        if (StringUtils.nonEmptyOrNull((String)event.getAggregateIdentifier())) {
            context = context.withResource(LegacyResources.AGGREGATE_SEQUENCE_NUMBER_KEY, (Object)event.getAggregateSequenceNumber()).withResource(LegacyResources.AGGREGATE_TYPE_KEY, (Object)event.getAggregateType()).withResource(LegacyResources.AGGREGATE_IDENTIFIER_KEY, (Object)event.getAggregateIdentifier());
        }
        return new SimpleEntry((Message)message, context);
    }

    public Optional<MessageStream.Entry<EventMessage>> peek() {
        EventWithToken eventWithToken = (EventWithToken)this.stream.peek();
        if (eventWithToken == null) {
            return Optional.empty();
        }
        SimpleEntry<EventMessage> entry = this.toSimpleEntry(eventWithToken);
        return Optional.of(entry);
    }

    public void setCallback(@Nonnull Runnable callback) {
        this.stream.onAvailable(callback);
    }

    public Optional<Throwable> error() {
        return this.stream.getError();
    }

    public boolean isCompleted() {
        return this.stream.isClosed();
    }

    public boolean hasNextAvailable() {
        return this.stream.peek() != null;
    }

    public void close() {
        this.stream.close();
    }
}

