/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector;

import io.axoniq.axonserver.grpc.ErrorMessage;
import java.util.Arrays;
import java.util.function.Supplier;
import org.axonframework.axonserver.connector.AxonServerException;
import org.axonframework.axonserver.connector.command.AxonServerCommandDispatchException;
import org.axonframework.axonserver.connector.command.AxonServerNonTransientRemoteCommandHandlingException;
import org.axonframework.axonserver.connector.command.AxonServerRemoteCommandHandlingException;
import org.axonframework.axonserver.connector.query.AxonServerNonTransientRemoteQueryHandlingException;
import org.axonframework.axonserver.connector.query.AxonServerQueryDispatchException;
import org.axonframework.axonserver.connector.query.AxonServerRemoteQueryHandlingException;
import org.axonframework.axonserver.connector.util.ExceptionConverter;
import org.axonframework.commandhandling.CommandExecutionException;
import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.common.AxonException;
import org.axonframework.common.ExceptionUtils;
import org.axonframework.eventsourcing.eventstore.EventStoreException;
import org.axonframework.messaging.EventPublicationFailedException;
import org.axonframework.messaging.HandlerExecutionException;
import org.axonframework.modelling.ConcurrencyException;
import org.axonframework.queryhandling.NoHandlerForQueryException;
import org.axonframework.queryhandling.QueryExecutionException;

public enum ErrorCode {
    AUTHENTICATION_TOKEN_MISSING("AXONIQ-1000", (code, error, details) -> new AxonServerException(code, error)),
    AUTHENTICATION_INVALID_TOKEN("AXONIQ-1001", (code, error, details) -> new AxonServerException(code, error)),
    UNSUPPORTED_INSTRUCTION("AXONIQ-1002", (code, error, details) -> new AxonServerException(code, error)),
    INSTRUCTION_ACK_ERROR("AXONIQ-1003", (code, error, details) -> new AxonServerException(code, error)),
    INSTRUCTION_EXECUTION_ERROR("AXONIQ-1004", (code, error, details) -> new AxonServerException(code, error)),
    INVALID_EVENT_SEQUENCE("AXONIQ-2000", (code, error, details) -> new ConcurrencyException(error.getMessage(), (Throwable)((Object)new AxonServerException(code, error)))),
    NO_EVENT_STORE_MASTER_AVAILABLE("AXONIQ-2100", (code, error, details) -> new EventPublicationFailedException(error.getMessage(), (Throwable)((Object)new AxonServerException(code, error)))),
    EVENT_PAYLOAD_TOO_LARGE("AXONIQ-2001", (code, error, details) -> new EventPublicationFailedException(error.getMessage(), (Throwable)((Object)new AxonServerException(code, error)))),
    CONNECTION_FAILED("AXONIQ-3001", (code, error, details) -> new AxonServerException(code, error)),
    GRPC_MESSAGE_TOO_LARGE("AXONIQ-3002", (code, error, details) -> new AxonServerException(code, error)),
    NO_HANDLER_FOR_COMMAND("AXONIQ-4000", (code, error, details) -> new NoHandlerForCommandException(error.getMessage())),
    COMMAND_EXECUTION_ERROR("AXONIQ-4002", (code, error, details) -> new CommandExecutionException(error.getMessage(), (Throwable)((Object)new AxonServerRemoteCommandHandlingException(code, error)), details.get())),
    COMMAND_DISPATCH_ERROR("AXONIQ-4003", (code, error, details) -> new AxonServerCommandDispatchException(code, error)),
    CONCURRENCY_EXCEPTION("AXONIQ-4004", (code, error, details) -> new ConcurrencyException(error.getMessage(), (Throwable)((Object)new AxonServerRemoteCommandHandlingException(code, error)))),
    COMMAND_EXECUTION_NON_TRANSIENT_ERROR("AXONIQ-4005", (code, error, details) -> new CommandExecutionException(error.getMessage(), (Throwable)((Object)new AxonServerNonTransientRemoteCommandHandlingException(code, error)), details.get())),
    NO_HANDLER_FOR_QUERY("AXONIQ-5000", (code, error, details) -> new NoHandlerForQueryException(error.getMessage())),
    QUERY_EXECUTION_ERROR("AXONIQ-5001", (code, error, details) -> new QueryExecutionException(error.getMessage(), (Throwable)((Object)new AxonServerRemoteQueryHandlingException(code, error)), details.get())),
    QUERY_DISPATCH_ERROR("AXONIQ-5002", (code, error, details) -> new AxonServerQueryDispatchException(code, error)),
    QUERY_EXECUTION_NON_TRANSIENT_ERROR("AXONIQ-5003", (code, error, details) -> new QueryExecutionException(error.getMessage(), (Throwable)((Object)new AxonServerNonTransientRemoteQueryHandlingException(code, error)), details.get())),
    DATAFILE_READ_ERROR("AXONIQ-9000", (code, error, details) -> new EventStoreException(error.getMessage(), (Throwable)((Object)new AxonServerException(code, error)))),
    INDEX_READ_ERROR("AXONIQ-9001", (code, error, details) -> new EventStoreException(error.getMessage(), (Throwable)((Object)new AxonServerException(code, error)))),
    DATAFILE_WRITE_ERROR("AXONIQ-9100", (code, error, details) -> new EventStoreException(error.getMessage(), (Throwable)((Object)new AxonServerException(code, error)))),
    INDEX_WRITE_ERROR("AXONIQ-9101", (code, error, details) -> new EventStoreException(error.getMessage(), (Throwable)((Object)new AxonServerException(code, error)))),
    DIRECTORY_CREATION_FAILED("AXONIQ-9102", (code, error, details) -> new EventStoreException(error.getMessage(), (Throwable)((Object)new AxonServerException(code, error)))),
    VALIDATION_FAILED("AXONIQ-9200", (code, error, details) -> new EventStoreException(error.getMessage(), (Throwable)((Object)new AxonServerException(code, error)))),
    TRANSACTION_ROLLED_BACK("AXONIQ-9900", (code, error, details) -> new EventStoreException(error.getMessage(), (Throwable)((Object)new AxonServerException(code, error)))),
    OTHER("AXONIQ-0001", (code, error, details) -> new AxonServerException(code, error));

    private final String errorCode;
    private final ExceptionBuilder exceptionBuilder;

    public static ErrorCode getFromCode(String code) {
        return Arrays.stream(ErrorCode.values()).filter(value -> value.errorCode.equals(code)).findFirst().orElse(OTHER);
    }

    private ErrorCode(String errorCode, ExceptionBuilder exceptionBuilder) {
        this.errorCode = errorCode;
        this.exceptionBuilder = exceptionBuilder;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public AxonException convert(ErrorMessage errorMessage, Supplier<Object> details) {
        if (details == null) {
            return this.convert(errorMessage);
        }
        return this.exceptionBuilder.buildException(this.errorCode, errorMessage, details);
    }

    public AxonException convert(ErrorMessage errorMessage) {
        return this.exceptionBuilder.buildException(this.errorCode, errorMessage, () -> null);
    }

    public AxonException convert(Throwable throwable) {
        return this.convert("", throwable);
    }

    public AxonException convert(String source, Throwable throwable) {
        return this.convert(ExceptionConverter.convertToErrorMessage(source, null, throwable), () -> HandlerExecutionException.resolveDetails((Throwable)throwable).orElse(null));
    }

    public static ErrorCode getQueryExecutionErrorCode(Throwable throwable) {
        if (ExceptionUtils.isExplicitlyNonTransient((Throwable)throwable)) {
            return QUERY_EXECUTION_NON_TRANSIENT_ERROR;
        }
        return QUERY_EXECUTION_ERROR;
    }

    public static ErrorCode getCommandExecutionErrorCode(Throwable throwable) {
        if (ExceptionUtils.isExplicitlyNonTransient((Throwable)throwable)) {
            return COMMAND_EXECUTION_NON_TRANSIENT_ERROR;
        }
        return COMMAND_EXECUTION_ERROR;
    }

    @FunctionalInterface
    private static interface ExceptionBuilder {
        public AxonException buildException(String var1, ErrorMessage var2, Supplier<Object> var3);
    }
}

