/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.query;

import com.google.protobuf.ByteString;
import io.axoniq.axonserver.grpc.MetaDataValue;
import io.axoniq.axonserver.grpc.ProcessingInstruction;
import io.axoniq.axonserver.grpc.ProcessingKey;
import io.axoniq.axonserver.grpc.SerializedObject;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import io.axoniq.axonserver.grpc.query.QueryUpdate;
import io.axoniq.axonserver.grpc.query.SubscriptionQuery;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.axonframework.axonserver.connector.ErrorCode;
import org.axonframework.axonserver.connector.MetadataConverter;
import org.axonframework.axonserver.connector.util.ExceptionConverter;
import org.axonframework.axonserver.connector.util.ProcessingInstructionUtils;
import org.axonframework.common.annotation.Internal;
import org.axonframework.messaging.core.GenericMessage;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageType;
import org.axonframework.messaging.queryhandling.GenericQueryMessage;
import org.axonframework.messaging.queryhandling.GenericQueryResponseMessage;
import org.axonframework.messaging.queryhandling.GenericSubscriptionQueryUpdateMessage;
import org.axonframework.messaging.queryhandling.QueryMessage;
import org.axonframework.messaging.queryhandling.QueryResponseMessage;
import org.axonframework.messaging.queryhandling.SubscriptionQueryUpdateMessage;

@Internal
public final class QueryConverter {
    @Nonnull
    public static QueryMessage convertQueryRequest(@Nonnull QueryRequest queryRequest) {
        SerializedObject payload = queryRequest.getPayload();
        Integer priority = ProcessingInstructionUtils.priority(queryRequest.getProcessingInstructionsList());
        MessageType type = new MessageType(payload.getType(), payload.getRevision());
        return new GenericQueryMessage((Message)new GenericMessage(queryRequest.getMessageIdentifier(), type, (Object)payload.getData().toByteArray(), MetadataConverter.convertMetadataValuesToGrpc(queryRequest.getMetaDataMap())), priority);
    }

    public static QueryRequest convertQueryMessage(@Nonnull QueryMessage query, @Nonnull String clientId, @Nonnull String componentName) {
        Object payload = query.payload();
        if (!(payload instanceof byte[])) {
            throw new IllegalArgumentException("Payload must be of type byte[] for AxonServerConnector, but was: " + query.payloadType().getName() + ", consider using a Converter-based QueryBusConnector");
        }
        byte[] payloadAsBytes = (byte[])payload;
        QueryRequest.Builder builder = QueryRequest.newBuilder();
        QueryConverter.addPriority(builder, query);
        return builder.setTimestamp(System.currentTimeMillis()).setClientId(clientId).setComponentName(componentName).setMessageIdentifier(query.identifier()).setQuery(query.type().name()).putAllMetaData(MetadataConverter.convertGrpcToMetadataValues((Map<String, String>)query.metadata())).setPayload(SerializedObject.newBuilder().setData(ByteString.copyFrom((byte[])payloadAsBytes)).setType(query.type().name()).setRevision(query.type().version()).build()).addProcessingInstructions(QueryConverter.nrOfResults(1)).addProcessingInstructions(QueryConverter.timeout(TimeUnit.HOURS.toMillis(1L))).addProcessingInstructions(QueryConverter.supportsStreaming()).build();
    }

    public static QueryResponseMessage convertQueryResponse(@Nonnull QueryResponse queryResponse) {
        if (queryResponse.hasErrorMessage()) {
            throw new IllegalArgumentException("Query Response contained an error.");
        }
        SerializedObject responsePayload = queryResponse.getPayload();
        GenericMessage message = new GenericMessage(queryResponse.getMessageIdentifier(), new MessageType(responsePayload.getType(), responsePayload.getRevision()), (Object)responsePayload.getData().toByteArray(), MetadataConverter.convertMetadataValuesToGrpc(queryResponse.getMetaDataMap()));
        return new GenericQueryResponseMessage((Message)message);
    }

    public static QueryResponse convertQueryResponseMessage(@Nonnull String requestId, @Nonnull QueryResponseMessage queryResponseMessage) {
        byte[] payload = Objects.requireNonNullElseGet((byte[])queryResponseMessage.payloadAs(byte[].class), () -> new byte[0]);
        return QueryResponse.newBuilder().setMessageIdentifier(queryResponseMessage.identifier()).setRequestIdentifier(requestId).setPayload(SerializedObject.newBuilder().setType(queryResponseMessage.type().name()).setRevision(queryResponseMessage.type().version()).setData(ByteString.copyFrom((byte[])payload)).build()).putAllMetaData(MetadataConverter.convertGrpcToMetadataValues((Map<String, String>)queryResponseMessage.metadata())).build();
    }

    public static QueryMessage convertSubscriptionQueryMessage(@Nonnull SubscriptionQuery query) {
        SerializedObject responsePayload = query.getQueryRequest().getPayload();
        GenericMessage message = new GenericMessage(query.getSubscriptionIdentifier(), new MessageType(responsePayload.getType(), responsePayload.getRevision()), (Object)responsePayload.getData().toByteArray(), MetadataConverter.convertMetadataValuesToGrpc(query.getQueryRequest().getMetaDataMap()));
        return new GenericQueryMessage((Message)message);
    }

    public static QueryUpdate convertQueryUpdate(@Nonnull SubscriptionQueryUpdateMessage update) {
        byte[] payload = Objects.requireNonNullElseGet((byte[])update.payloadAs(byte[].class), () -> new byte[0]);
        return QueryUpdate.newBuilder().setMessageIdentifier(update.identifier()).setPayload(SerializedObject.newBuilder().setType(update.type().name()).setRevision(update.type().version()).setData(ByteString.copyFrom((byte[])payload)).build()).putAllMetaData(MetadataConverter.convertGrpcToMetadataValues((Map<String, String>)update.metadata())).build();
    }

    public static SubscriptionQueryUpdateMessage convertQueryUpdate(@Nonnull QueryUpdate queryUpdate) {
        SerializedObject payload = queryUpdate.getPayload();
        GenericMessage message = new GenericMessage(queryUpdate.getMessageIdentifier(), new MessageType(payload.getType(), payload.getRevision()), (Object)payload.getData().toByteArray(), MetadataConverter.convertMetadataValuesToGrpc(queryUpdate.getMetaDataMap()));
        return new GenericSubscriptionQueryUpdateMessage((Message)message);
    }

    public static QueryUpdate convertQueryUpdate(String clientId, @Nullable ErrorCode errorCode, Throwable error) {
        QueryUpdate.Builder builder = QueryUpdate.newBuilder().setErrorMessage(ExceptionConverter.convertToErrorMessage(clientId, errorCode, error)).setClientId(clientId);
        if (errorCode != null) {
            builder.setErrorCode(errorCode.errorCode());
        }
        return builder.build();
    }

    private static void addPriority(QueryRequest.Builder builder, QueryMessage query) {
        query.priority().ifPresent(priority -> {
            ProcessingInstruction.Builder instruction = ProcessingInstructionUtils.createProcessingInstruction(ProcessingKey.PRIORITY, MetaDataValue.newBuilder().setNumberValue((long)priority));
            builder.addProcessingInstructions(instruction);
        });
    }

    private static ProcessingInstruction.Builder nrOfResults(int nrOfResults) {
        return ProcessingInstructionUtils.createProcessingInstruction(ProcessingKey.NR_OF_RESULTS, nrOfResults);
    }

    private static ProcessingInstruction.Builder timeout(long timeout) {
        return ProcessingInstructionUtils.createProcessingInstruction(ProcessingKey.TIMEOUT, timeout);
    }

    private static ProcessingInstruction.Builder supportsStreaming() {
        return ProcessingInstructionUtils.createProcessingInstruction(ProcessingKey.CLIENT_SUPPORTS_STREAMING, true);
    }

    private QueryConverter() {
    }
}

