/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.query;

import com.google.protobuf.ByteString;
import io.axoniq.axonserver.grpc.MetaDataValue;
import io.axoniq.axonserver.grpc.ProcessingInstruction;
import io.axoniq.axonserver.grpc.ProcessingKey;
import io.axoniq.axonserver.grpc.SerializedObject;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import io.axoniq.axonserver.grpc.query.QueryUpdate;
import io.axoniq.axonserver.grpc.query.SubscriptionQuery;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.axonframework.axonserver.connector.MetadataConverter;
import org.axonframework.axonserver.connector.util.ExceptionConverter;
import org.axonframework.axonserver.connector.util.ProcessingInstructionUtils;
import org.axonframework.common.annotations.Internal;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageType;
import org.axonframework.queryhandling.GenericQueryMessage;
import org.axonframework.queryhandling.GenericQueryResponseMessage;
import org.axonframework.queryhandling.GenericSubscriptionQueryMessage;
import org.axonframework.queryhandling.GenericSubscriptionQueryUpdateMessage;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;

@Internal
public final class QueryConverter {
    @Nonnull
    public static QueryMessage convertQueryRequest(@Nonnull QueryRequest queryRequest) {
        SerializedObject payload = queryRequest.getPayload();
        Integer priority = ProcessingInstructionUtils.priority(queryRequest.getProcessingInstructionsList());
        MessageType type = new MessageType(payload.getType(), payload.getRevision());
        MessageType responseType = new MessageType(queryRequest.getResponseType().getType(), queryRequest.getResponseType().getRevision());
        return new GenericQueryMessage((Message)new GenericMessage(queryRequest.getMessageIdentifier(), type, (Object)payload.getData().toByteArray(), MetadataConverter.convertMetadataValuesToGrpc(queryRequest.getMetaDataMap())), responseType, priority);
    }

    public static QueryRequest convertQueryMessage(@Nonnull QueryMessage query, @Nonnull String clientId, @Nonnull String componentName) {
        Object payload = query.payload();
        if (!(payload instanceof byte[])) {
            throw new IllegalArgumentException("Payload must be of type byte[] for AxonServerConnector, but was: " + query.payloadType().getName() + ", consider using a Converter-based QueryBusConnector");
        }
        byte[] payloadAsBytes = (byte[])payload;
        QueryRequest.Builder builder = QueryRequest.newBuilder();
        QueryConverter.addPriority(builder, query);
        return builder.setTimestamp(System.currentTimeMillis()).setClientId(clientId).setComponentName(componentName).setMessageIdentifier(query.identifier()).setQuery(query.type().name()).setResponseType(SerializedObject.newBuilder().setType(query.responseType().name()).setRevision(query.responseType().version()).build()).putAllMetaData(MetadataConverter.convertGrpcToMetadataValues((Map<String, String>)query.metadata())).setPayload(SerializedObject.newBuilder().setData(ByteString.copyFrom((byte[])payloadAsBytes)).setType(query.type().name()).setRevision(query.type().version()).build()).addProcessingInstructions(QueryConverter.nrOfResults(1)).addProcessingInstructions(QueryConverter.timeout(TimeUnit.HOURS.toMillis(1L))).addProcessingInstructions(QueryConverter.supportsStreaming()).build();
    }

    public static QueryResponseMessage convertQueryResponse(@Nonnull QueryResponse queryResponse) {
        if (queryResponse.hasErrorMessage()) {
            throw new IllegalArgumentException("Query Response contained an error.");
        }
        SerializedObject responsePayload = queryResponse.getPayload();
        GenericMessage message = new GenericMessage(queryResponse.getMessageIdentifier(), new MessageType(responsePayload.getType(), responsePayload.getRevision()), (Object)responsePayload.getData().toByteArray(), MetadataConverter.convertMetadataValuesToGrpc(queryResponse.getMetaDataMap()));
        return new GenericQueryResponseMessage((Message)message);
    }

    public static QueryResponse convertQueryResponseMessage(@Nonnull String requestId, @Nonnull QueryResponseMessage queryResponseMessage) {
        byte[] payload = Objects.requireNonNullElseGet((byte[])queryResponseMessage.payloadAs(byte[].class), () -> new byte[0]);
        return QueryResponse.newBuilder().setMessageIdentifier(queryResponseMessage.identifier()).setRequestIdentifier(requestId).setPayload(SerializedObject.newBuilder().setType(queryResponseMessage.type().name()).setRevision(queryResponseMessage.type().version()).setData(ByteString.copyFrom((byte[])payload)).build()).putAllMetaData(MetadataConverter.convertGrpcToMetadataValues((Map<String, String>)queryResponseMessage.metadata())).build();
    }

    public static SubscriptionQueryMessage convertSubscriptionQueryMessage(@Nonnull SubscriptionQuery query) {
        SerializedObject responsePayload = query.getQueryRequest().getPayload();
        GenericMessage message = new GenericMessage(query.getSubscriptionIdentifier(), new MessageType(responsePayload.getType(), responsePayload.getRevision()), (Object)responsePayload.getData().toByteArray(), MetadataConverter.convertMetadataValuesToGrpc(query.getQueryRequest().getMetaDataMap()));
        return new GenericSubscriptionQueryMessage((Message)message, new MessageType(query.getQueryRequest().getResponseType().getType(), query.getQueryRequest().getResponseType().getRevision()));
    }

    public static QueryUpdate convertQueryUpdate(@Nonnull SubscriptionQueryUpdateMessage update) {
        byte[] payload = Objects.requireNonNullElseGet((byte[])update.payloadAs(byte[].class), () -> new byte[0]);
        return QueryUpdate.newBuilder().setMessageIdentifier(update.identifier()).setPayload(SerializedObject.newBuilder().setType(update.type().name()).setRevision(update.type().version()).setData(ByteString.copyFrom((byte[])payload)).build()).putAllMetaData(MetadataConverter.convertGrpcToMetadataValues((Map<String, String>)update.metadata())).build();
    }

    public static SubscriptionQueryUpdateMessage convertQueryUpdate(@Nonnull QueryUpdate queryUpdate) {
        SerializedObject payload = queryUpdate.getPayload();
        GenericMessage message = new GenericMessage(queryUpdate.getMessageIdentifier(), new MessageType(payload.getType(), payload.getRevision()), (Object)payload.getData().toByteArray(), MetadataConverter.convertMetadataValuesToGrpc(queryUpdate.getMetaDataMap()));
        return new GenericSubscriptionQueryUpdateMessage((Message)message);
    }

    public static QueryUpdate convertQueryUpdate(String clientId, Throwable error) {
        return QueryUpdate.newBuilder().setErrorMessage(ExceptionConverter.convertToErrorMessage(clientId, error)).setClientId(clientId).build();
    }

    private static void addPriority(QueryRequest.Builder builder, QueryMessage query) {
        query.priority().ifPresent(priority -> {
            ProcessingInstruction.Builder instruction = ProcessingInstructionUtils.createProcessingInstruction(ProcessingKey.PRIORITY, MetaDataValue.newBuilder().setNumberValue((long)priority));
            builder.addProcessingInstructions(instruction);
        });
    }

    private static ProcessingInstruction.Builder nrOfResults(int nrOfResults) {
        return ProcessingInstructionUtils.createProcessingInstruction(ProcessingKey.NR_OF_RESULTS, nrOfResults);
    }

    private static ProcessingInstruction.Builder timeout(long timeout) {
        return ProcessingInstructionUtils.createProcessingInstruction(ProcessingKey.TIMEOUT, timeout);
    }

    private static ProcessingInstruction.Builder supportsStreaming() {
        return ProcessingInstructionUtils.createProcessingInstruction(ProcessingKey.CLIENT_SUPPORTS_STREAMING, true);
    }

    private QueryConverter() {
    }
}

