/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.processor;

import io.axoniq.axonserver.grpc.control.EventProcessorInfo;
import java.util.List;
import java.util.stream.Collectors;
import org.axonframework.eventhandling.EventTrackerStatus;
import org.axonframework.eventhandling.StreamingEventProcessor;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.pooled.PooledStreamingEventProcessor;

public class StreamingEventProcessorInfoMessage {
    private StreamingEventProcessorInfoMessage() {
    }

    public static EventProcessorInfo describe(StreamingEventProcessor eventProcessor) {
        List segmentStatuses = eventProcessor.processingStatus().values().stream().map(StreamingEventProcessorInfoMessage::buildSegmentStatus).collect(Collectors.toList());
        return EventProcessorInfo.newBuilder().setProcessorName(eventProcessor.name()).setTokenStoreIdentifier(eventProcessor.getTokenStoreIdentifier()).setMode(StreamingEventProcessorInfoMessage.defineMode(eventProcessor.getClass())).setActiveThreads(eventProcessor.processingStatus().size()).setAvailableThreads(eventProcessor.maxCapacity() - eventProcessor.processingStatus().size()).setRunning(eventProcessor.isRunning()).setError(eventProcessor.isError()).addAllSegmentStatus(segmentStatuses).setIsStreamingProcessor(true).build();
    }

    private static String defineMode(Class<? extends StreamingEventProcessor> streamingProcessorClass) {
        if (streamingProcessorClass.isAssignableFrom(PooledStreamingEventProcessor.class)) {
            return "Pooled Streaming";
        }
        return "Streaming";
    }

    private static EventProcessorInfo.SegmentStatus buildSegmentStatus(EventTrackerStatus status) {
        return EventProcessorInfo.SegmentStatus.newBuilder().setSegmentId(status.getSegment().getSegmentId()).setCaughtUp(status.isCaughtUp()).setReplaying(status.isReplaying()).setOnePartOf(status.getSegment().getMask() + 1).setTokenPosition(StreamingEventProcessorInfoMessage.getPosition(status.getTrackingToken())).setErrorState(status.isErrorState() ? StreamingEventProcessorInfoMessage.buildErrorMessage(status.getError()) : "").build();
    }

    private static long getPosition(TrackingToken trackingToken) {
        long position = 0L;
        if (trackingToken != null) {
            position = trackingToken.position().orElse(0L);
        }
        return position;
    }

    private static String buildErrorMessage(Throwable error) {
        return error.getClass().getName() + ": " + error.getMessage();
    }
}

