/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector;

import io.axoniq.axonserver.grpc.control.UpdateType;
import java.util.Objects;
import java.util.OptionalInt;

public class TopologyChange {
    private final Type type;
    private final String context;
    private final String clientId;
    private final String clientStreamId;
    private final String componentName;
    private final HandlerSubscription handlerSubscription;

    public TopologyChange(Type type, String context, String clientId, String clientStreamId, String componentName, HandlerSubscription handlerSubscription) {
        this.type = type;
        this.context = context;
        this.clientId = clientId;
        this.clientStreamId = clientStreamId;
        this.componentName = componentName;
        this.handlerSubscription = handlerSubscription;
    }

    public TopologyChange(io.axoniq.axonserver.grpc.control.TopologyChange change) {
        this.type = this.mapToType(change.getUpdateType());
        this.context = change.getContext();
        this.clientId = change.getClientId();
        this.clientStreamId = change.getClientStreamId();
        this.componentName = change.getComponentName();
        this.handlerSubscription = change.hasCommand() ? new HandlerSubscription(change.getCommand().getName(), change.getCommand().getLoadFactor()) : (change.hasQuery() ? new HandlerSubscription(change.getQuery().getName(), null) : null);
    }

    private Type mapToType(UpdateType updateType) {
        Type result = null;
        switch (updateType) {
            case ADD_COMMAND_HANDLER: {
                result = Type.COMMAND_HANDLER_ADDED;
                break;
            }
            case REMOVE_COMMAND_HANDLER: {
                result = Type.COMMAND_HANDLER_REMOVED;
                break;
            }
            case ADD_QUERY_HANDLER: {
                result = Type.QUERY_HANDLER_ADDED;
                break;
            }
            case REMOVE_QUERY_HANDLER: {
                result = Type.QUERY_HANDLER_REMOVED;
                break;
            }
            case RESET_ALL: {
                result = Type.RESET;
            }
        }
        return result;
    }

    public Type type() {
        return this.type;
    }

    public String context() {
        return this.context;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientStreamId() {
        return this.clientStreamId;
    }

    public String componentName() {
        return this.componentName;
    }

    public HandlerSubscription handler() {
        return this.handlerSubscription;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologyChange that = (TopologyChange)o;
        return this.type == that.type && Objects.equals(this.context, that.context) && Objects.equals(this.clientId, that.clientId) && Objects.equals(this.clientStreamId, that.clientStreamId) && Objects.equals(this.componentName, that.componentName) && Objects.equals(this.handlerSubscription, that.handlerSubscription);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.context, this.clientId, this.clientStreamId, this.componentName, this.handlerSubscription});
    }

    public String toString() {
        return "TopologyChange{type=" + String.valueOf((Object)this.type) + ", context='" + this.context + "', clientId='" + this.clientId + "', clientStreamId='" + this.clientStreamId + "', componentName='" + this.componentName + "', handlerSubscription=" + String.valueOf(this.handlerSubscription) + "}";
    }

    public static enum Type {
        COMMAND_HANDLER_ADDED,
        COMMAND_HANDLER_REMOVED,
        QUERY_HANDLER_ADDED,
        QUERY_HANDLER_REMOVED,
        RESET;

    }

    public static class HandlerSubscription {
        private final String name;
        private final Integer loadFactor;

        public HandlerSubscription(String name, Integer loadFactor) {
            this.name = name;
            this.loadFactor = loadFactor;
        }

        public String name() {
            return this.name;
        }

        public OptionalInt loadFactor() {
            return this.loadFactor != null ? OptionalInt.of(this.loadFactor) : OptionalInt.empty();
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HandlerSubscription that = (HandlerSubscription)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.loadFactor, that.loadFactor);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.loadFactor);
        }

        public String toString() {
            return "HandlerSubscription{name='" + this.name + "', loadFactor=" + this.loadFactor + "}";
        }
    }
}

